/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class Reference {
    ReferenceType referenceType;
    ByteOrder byteOrder;
    BitOrder bitOrder;
    Boolean decodingIgnore;
    Boolean encodingIgnore;
    Class<?> protocolClass;
    ConstructorType constructorType;
    Field field;
    Annotation dataTypeAnnotation;
    ProtocolType protocolType;
    Class<? extends Function> decodingFormulaClass;
    Class<? extends Function> encodingFormulaClass;
    Function decodingFormula;
    Function decodingLambda;
    Function encodingFormula;
    Function encodingLambda;
    Function<ByteBufferInputStream, ?> decoder;
    BiConsumer<ByteBufferOutputStream, ? super Object> encoder;
    Supplier<Integer> lengthSupplier;
    ThreadLocal<Object> value;

    public void decode(ByteBufferInputStream inputStream) {
        Object value = this.decoder.apply(inputStream);
        this.setValue(value);
    }

    public void encoder(ByteBufferOutputStream outputStream) {
        this.encoder.accept(outputStream, this.getValue().get());
    }

    public Object newInstance() {
        try {
            Object object = this.protocolClass.newInstance();
            this.value.set(object);
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DecodingException(String.format("Fail decoding the class %s", this.protocolClass.getName()), e);
        }
    }

    public Object newInstance(Reference[] references) {
        Class[] types = (Class[])Arrays.stream(references).filter(r -> r.getReferenceType() != ReferenceType.INVALID).map(Reference::getField).map(Field::getType).toArray(Class[]::new);
        try {
            Constructor<?> constructor = this.protocolClass.getDeclaredConstructor(types);
            Object[] args = Arrays.stream(references).filter(r -> r.getReferenceType() != ReferenceType.INVALID).map(r -> r.getValue().get()).toArray();
            Object object = constructor.newInstance(args);
            this.value.set(object);
            return object;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new DecodingException(String.format("Fail decoding the class %s", this.protocolClass.getName()), e);
        }
    }

    public void setField(Reference reference) {
        Field field = reference.getField();
        if (this.value.get() != null && reference.getValue().get() != null) {
            try {
                field.set(this.value.get(), reference.getValue().get());
            }
            catch (IllegalAccessException e) {
                throw new DecodingException(String.format("Fail decoding the field %s of class %s", field, this.protocolClass.getName()), e);
            }
        }
    }

    public Object parse(Object object) {
        try {
            if (object == null) {
                return null;
            }
            if (this.field == null) {
                return object;
            }
            return this.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new EncodingException(String.format("Fail decoding the field %s of class %s", this.field, this.protocolClass.getName()), e);
        }
    }

    public void clear() {
        this.value.remove();
    }

    public void setValue(Object value) {
        this.value.set(value);
    }

    public boolean equals(Object other) {
        if (other instanceof Reference && this.referenceType == ReferenceType.CLASS && ((Reference)other).referenceType == ReferenceType.CLASS) {
            return this.protocolClass == ((Reference)other).protocolClass;
        }
        return super.equals(other);
    }

    public int hashCode() {
        if (this.referenceType == ReferenceType.CLASS) {
            return this.protocolClass.hashCode();
        }
        return super.hashCode();
    }

    @Generated
    private static Boolean $default$decodingIgnore() {
        return false;
    }

    @Generated
    private static Boolean $default$encodingIgnore() {
        return false;
    }

    @Generated
    private static ThreadLocal<Object> $default$value() {
        return new ThreadLocal<Object>();
    }

    @Generated
    public static ReferenceBuilder builder() {
        return new ReferenceBuilder();
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Generated
    public BitOrder getBitOrder() {
        return this.bitOrder;
    }

    @Generated
    public Boolean getDecodingIgnore() {
        return this.decodingIgnore;
    }

    @Generated
    public Boolean getEncodingIgnore() {
        return this.encodingIgnore;
    }

    @Generated
    public Class<?> getProtocolClass() {
        return this.protocolClass;
    }

    @Generated
    public ConstructorType getConstructorType() {
        return this.constructorType;
    }

    @Generated
    public Field getField() {
        return this.field;
    }

    @Generated
    public Annotation getDataTypeAnnotation() {
        return this.dataTypeAnnotation;
    }

    @Generated
    public ProtocolType getProtocolType() {
        return this.protocolType;
    }

    @Generated
    public Class<? extends Function> getDecodingFormulaClass() {
        return this.decodingFormulaClass;
    }

    @Generated
    public Class<? extends Function> getEncodingFormulaClass() {
        return this.encodingFormulaClass;
    }

    @Generated
    public Function getDecodingFormula() {
        return this.decodingFormula;
    }

    @Generated
    public Function getDecodingLambda() {
        return this.decodingLambda;
    }

    @Generated
    public Function getEncodingFormula() {
        return this.encodingFormula;
    }

    @Generated
    public Function getEncodingLambda() {
        return this.encodingLambda;
    }

    @Generated
    public Function<ByteBufferInputStream, ?> getDecoder() {
        return this.decoder;
    }

    @Generated
    public BiConsumer<ByteBufferOutputStream, ? super Object> getEncoder() {
        return this.encoder;
    }

    @Generated
    public Supplier<Integer> getLengthSupplier() {
        return this.lengthSupplier;
    }

    @Generated
    public ThreadLocal<Object> getValue() {
        return this.value;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Generated
    public void setBitOrder(BitOrder bitOrder) {
        this.bitOrder = bitOrder;
    }

    @Generated
    public void setDecodingIgnore(Boolean decodingIgnore) {
        this.decodingIgnore = decodingIgnore;
    }

    @Generated
    public void setEncodingIgnore(Boolean encodingIgnore) {
        this.encodingIgnore = encodingIgnore;
    }

    @Generated
    public void setProtocolClass(Class<?> protocolClass) {
        this.protocolClass = protocolClass;
    }

    @Generated
    public void setConstructorType(ConstructorType constructorType) {
        this.constructorType = constructorType;
    }

    @Generated
    public void setDataTypeAnnotation(Annotation dataTypeAnnotation) {
        this.dataTypeAnnotation = dataTypeAnnotation;
    }

    @Generated
    public void setProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    @Generated
    public void setDecodingFormulaClass(Class<? extends Function> decodingFormulaClass) {
        this.decodingFormulaClass = decodingFormulaClass;
    }

    @Generated
    public void setEncodingFormulaClass(Class<? extends Function> encodingFormulaClass) {
        this.encodingFormulaClass = encodingFormulaClass;
    }

    @Generated
    public void setDecodingFormula(Function decodingFormula) {
        this.decodingFormula = decodingFormula;
    }

    @Generated
    public void setDecodingLambda(Function decodingLambda) {
        this.decodingLambda = decodingLambda;
    }

    @Generated
    public void setEncodingFormula(Function encodingFormula) {
        this.encodingFormula = encodingFormula;
    }

    @Generated
    public void setEncodingLambda(Function encodingLambda) {
        this.encodingLambda = encodingLambda;
    }

    @Generated
    public void setDecoder(Function<ByteBufferInputStream, ?> decoder) {
        this.decoder = decoder;
    }

    @Generated
    public void setEncoder(BiConsumer<ByteBufferOutputStream, ? super Object> encoder) {
        this.encoder = encoder;
    }

    @Generated
    public void setLengthSupplier(Supplier<Integer> lengthSupplier) {
        this.lengthSupplier = lengthSupplier;
    }

    @Generated
    public String toString() {
        return "Reference(referenceType=" + (Object)((Object)this.getReferenceType()) + ", byteOrder=" + (Object)((Object)this.getByteOrder()) + ", bitOrder=" + (Object)((Object)this.getBitOrder()) + ", decodingIgnore=" + this.getDecodingIgnore() + ", encodingIgnore=" + this.getEncodingIgnore() + ", protocolClass=" + this.getProtocolClass() + ", constructorType=" + (Object)((Object)this.getConstructorType()) + ", field=" + this.getField() + ", dataTypeAnnotation=" + this.getDataTypeAnnotation() + ", protocolType=" + this.getProtocolType() + ", decodingFormulaClass=" + this.getDecodingFormulaClass() + ", encodingFormulaClass=" + this.getEncodingFormulaClass() + ", decodingFormula=" + this.getDecodingFormula() + ", decodingLambda=" + this.getDecodingLambda() + ", encodingFormula=" + this.getEncodingFormula() + ", encodingLambda=" + this.getEncodingLambda() + ", decoder=" + this.getDecoder() + ", encoder=" + this.getEncoder() + ", lengthSupplier=" + this.getLengthSupplier() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public Reference() {
        this.decodingIgnore = Reference.$default$decodingIgnore();
        this.encodingIgnore = Reference.$default$encodingIgnore();
        this.value = Reference.$default$value();
    }

    @Generated
    public Reference(ReferenceType referenceType, ByteOrder byteOrder, BitOrder bitOrder, Boolean decodingIgnore, Boolean encodingIgnore, Class<?> protocolClass, ConstructorType constructorType, Field field, Annotation dataTypeAnnotation, ProtocolType protocolType, Class<? extends Function> decodingFormulaClass, Class<? extends Function> encodingFormulaClass, Function decodingFormula, Function decodingLambda, Function encodingFormula, Function encodingLambda, Function<ByteBufferInputStream, ?> decoder, BiConsumer<ByteBufferOutputStream, ? super Object> encoder, Supplier<Integer> lengthSupplier, ThreadLocal<Object> value) {
        this.referenceType = referenceType;
        this.byteOrder = byteOrder;
        this.bitOrder = bitOrder;
        this.decodingIgnore = decodingIgnore;
        this.encodingIgnore = encodingIgnore;
        this.protocolClass = protocolClass;
        this.constructorType = constructorType;
        this.field = field;
        this.dataTypeAnnotation = dataTypeAnnotation;
        this.protocolType = protocolType;
        this.decodingFormulaClass = decodingFormulaClass;
        this.encodingFormulaClass = encodingFormulaClass;
        this.decodingFormula = decodingFormula;
        this.decodingLambda = decodingLambda;
        this.encodingFormula = encodingFormula;
        this.encodingLambda = encodingLambda;
        this.decoder = decoder;
        this.encoder = encoder;
        this.lengthSupplier = lengthSupplier;
        this.value = value;
    }

    @Generated
    public Reference withReferenceType(ReferenceType referenceType) {
        return this.referenceType == referenceType ? this : new Reference(referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withByteOrder(ByteOrder byteOrder) {
        return this.byteOrder == byteOrder ? this : new Reference(this.referenceType, byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withBitOrder(BitOrder bitOrder) {
        return this.bitOrder == bitOrder ? this : new Reference(this.referenceType, this.byteOrder, bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withDecodingIgnore(Boolean decodingIgnore) {
        return this.decodingIgnore == decodingIgnore ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withEncodingIgnore(Boolean encodingIgnore) {
        return this.encodingIgnore == encodingIgnore ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withProtocolClass(Class<?> protocolClass) {
        return this.protocolClass == protocolClass ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withConstructorType(ConstructorType constructorType) {
        return this.constructorType == constructorType ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withField(Field field) {
        return this.field == field ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withDataTypeAnnotation(Annotation dataTypeAnnotation) {
        return this.dataTypeAnnotation == dataTypeAnnotation ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withProtocolType(ProtocolType protocolType) {
        return this.protocolType == protocolType ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withDecodingFormulaClass(Class<? extends Function> decodingFormulaClass) {
        return this.decodingFormulaClass == decodingFormulaClass ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withEncodingFormulaClass(Class<? extends Function> encodingFormulaClass) {
        return this.encodingFormulaClass == encodingFormulaClass ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withDecodingFormula(Function decodingFormula) {
        return this.decodingFormula == decodingFormula ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withDecodingLambda(Function decodingLambda) {
        return this.decodingLambda == decodingLambda ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withEncodingFormula(Function encodingFormula) {
        return this.encodingFormula == encodingFormula ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withEncodingLambda(Function encodingLambda) {
        return this.encodingLambda == encodingLambda ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, encodingLambda, this.decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withDecoder(Function<ByteBufferInputStream, ?> decoder) {
        return this.decoder == decoder ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, decoder, this.encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withEncoder(BiConsumer<ByteBufferOutputStream, ? super Object> encoder) {
        return this.encoder == encoder ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, encoder, this.lengthSupplier, this.value);
    }

    @Generated
    public Reference withLengthSupplier(Supplier<Integer> lengthSupplier) {
        return this.lengthSupplier == lengthSupplier ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, lengthSupplier, this.value);
    }

    @Generated
    public Reference withValue(ThreadLocal<Object> value) {
        return this.value == value ? this : new Reference(this.referenceType, this.byteOrder, this.bitOrder, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, value);
    }

    @Generated
    public static class ReferenceBuilder {
        @Generated
        private ReferenceType referenceType;
        @Generated
        private ByteOrder byteOrder;
        @Generated
        private BitOrder bitOrder;
        @Generated
        private boolean decodingIgnore$set;
        @Generated
        private Boolean decodingIgnore$value;
        @Generated
        private boolean encodingIgnore$set;
        @Generated
        private Boolean encodingIgnore$value;
        @Generated
        private Class<?> protocolClass;
        @Generated
        private ConstructorType constructorType;
        @Generated
        private Field field;
        @Generated
        private Annotation dataTypeAnnotation;
        @Generated
        private ProtocolType protocolType;
        @Generated
        private Class<? extends Function> decodingFormulaClass;
        @Generated
        private Class<? extends Function> encodingFormulaClass;
        @Generated
        private Function decodingFormula;
        @Generated
        private Function decodingLambda;
        @Generated
        private Function encodingFormula;
        @Generated
        private Function encodingLambda;
        @Generated
        private Function<ByteBufferInputStream, ?> decoder;
        @Generated
        private BiConsumer<ByteBufferOutputStream, ? super Object> encoder;
        @Generated
        private Supplier<Integer> lengthSupplier;
        @Generated
        private boolean value$set;
        @Generated
        private ThreadLocal<Object> value$value;

        @Generated
        ReferenceBuilder() {
        }

        @Generated
        public ReferenceBuilder referenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Generated
        public ReferenceBuilder byteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        @Generated
        public ReferenceBuilder bitOrder(BitOrder bitOrder) {
            this.bitOrder = bitOrder;
            return this;
        }

        @Generated
        public ReferenceBuilder decodingIgnore(Boolean decodingIgnore) {
            this.decodingIgnore$value = decodingIgnore;
            this.decodingIgnore$set = true;
            return this;
        }

        @Generated
        public ReferenceBuilder encodingIgnore(Boolean encodingIgnore) {
            this.encodingIgnore$value = encodingIgnore;
            this.encodingIgnore$set = true;
            return this;
        }

        @Generated
        public ReferenceBuilder protocolClass(Class<?> protocolClass) {
            this.protocolClass = protocolClass;
            return this;
        }

        @Generated
        public ReferenceBuilder constructorType(ConstructorType constructorType) {
            this.constructorType = constructorType;
            return this;
        }

        @Generated
        public ReferenceBuilder field(Field field) {
            this.field = field;
            return this;
        }

        @Generated
        public ReferenceBuilder dataTypeAnnotation(Annotation dataTypeAnnotation) {
            this.dataTypeAnnotation = dataTypeAnnotation;
            return this;
        }

        @Generated
        public ReferenceBuilder protocolType(ProtocolType protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Generated
        public ReferenceBuilder decodingFormulaClass(Class<? extends Function> decodingFormulaClass) {
            this.decodingFormulaClass = decodingFormulaClass;
            return this;
        }

        @Generated
        public ReferenceBuilder encodingFormulaClass(Class<? extends Function> encodingFormulaClass) {
            this.encodingFormulaClass = encodingFormulaClass;
            return this;
        }

        @Generated
        public ReferenceBuilder decodingFormula(Function decodingFormula) {
            this.decodingFormula = decodingFormula;
            return this;
        }

        @Generated
        public ReferenceBuilder decodingLambda(Function decodingLambda) {
            this.decodingLambda = decodingLambda;
            return this;
        }

        @Generated
        public ReferenceBuilder encodingFormula(Function encodingFormula) {
            this.encodingFormula = encodingFormula;
            return this;
        }

        @Generated
        public ReferenceBuilder encodingLambda(Function encodingLambda) {
            this.encodingLambda = encodingLambda;
            return this;
        }

        @Generated
        public ReferenceBuilder decoder(Function<ByteBufferInputStream, ?> decoder) {
            this.decoder = decoder;
            return this;
        }

        @Generated
        public ReferenceBuilder encoder(BiConsumer<ByteBufferOutputStream, ? super Object> encoder) {
            this.encoder = encoder;
            return this;
        }

        @Generated
        public ReferenceBuilder lengthSupplier(Supplier<Integer> lengthSupplier) {
            this.lengthSupplier = lengthSupplier;
            return this;
        }

        @Generated
        public ReferenceBuilder value(ThreadLocal<Object> value) {
            this.value$value = value;
            this.value$set = true;
            return this;
        }

        @Generated
        public Reference build() {
            Boolean decodingIgnore$value = this.decodingIgnore$value;
            if (!this.decodingIgnore$set) {
                decodingIgnore$value = Reference.$default$decodingIgnore();
            }
            Boolean encodingIgnore$value = this.encodingIgnore$value;
            if (!this.encodingIgnore$set) {
                encodingIgnore$value = Reference.$default$encodingIgnore();
            }
            ThreadLocal value$value = this.value$value;
            if (!this.value$set) {
                value$value = Reference.$default$value();
            }
            return new Reference(this.referenceType, this.byteOrder, this.bitOrder, decodingIgnore$value, encodingIgnore$value, this.protocolClass, this.constructorType, this.field, this.dataTypeAnnotation, this.protocolType, this.decodingFormulaClass, this.encodingFormulaClass, this.decodingFormula, this.decodingLambda, this.encodingFormula, this.encodingLambda, this.decoder, this.encoder, this.lengthSupplier, value$value);
        }

        @Generated
        public String toString() {
            return "Reference.ReferenceBuilder(referenceType=" + (Object)((Object)this.referenceType) + ", byteOrder=" + (Object)((Object)this.byteOrder) + ", bitOrder=" + (Object)((Object)this.bitOrder) + ", decodingIgnore$value=" + this.decodingIgnore$value + ", encodingIgnore$value=" + this.encodingIgnore$value + ", protocolClass=" + this.protocolClass + ", constructorType=" + (Object)((Object)this.constructorType) + ", field=" + this.field + ", dataTypeAnnotation=" + this.dataTypeAnnotation + ", protocolType=" + this.protocolType + ", decodingFormulaClass=" + this.decodingFormulaClass + ", encodingFormulaClass=" + this.encodingFormulaClass + ", decodingFormula=" + this.decodingFormula + ", decodingLambda=" + this.decodingLambda + ", encodingFormula=" + this.encodingFormula + ", encodingLambda=" + this.encodingLambda + ", decoder=" + this.decoder + ", encoder=" + this.encoder + ", lengthSupplier=" + this.lengthSupplier + ", value$value=" + this.value$value + ")";
        }
    }

    public static enum ConstructorType {
        NO_ARGS,
        ALL_ARGS;

    }

    public static enum ReferenceType {
        CLASS,
        FIELD,
        INVALID;

    }
}

