/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.indunet.fastproto.annotation.AutoType;
import org.indunet.fastproto.annotation.DataType;
import org.indunet.fastproto.exception.ResolvingException;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.mapper.CodecMapper;

public class Resolver {
    protected static ConcurrentHashMap<Class<?>, Graph> graphs = new ConcurrentHashMap();
    protected static ResolvePipeline resolveClassFlow = ResolvePipeline.getClassPipeline();
    protected static ResolvePipeline resolveFieldFlow = ResolvePipeline.getFieldPipeline();
    private static final Predicate<Field> IS_CLASS_CONDITION = f -> CodecMapper.isSupported(f.getType());
    private static final Predicate<Field> IS_DATA_CONDITION = f -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).anyMatch(t -> t.isAnnotationPresent(DataType.class));

    public static Graph resolve(Class<?> protocolClass) {
        return graphs.computeIfAbsent(protocolClass, __ -> {
            boolean hasLength;
            Graph graph = new Graph();
            ArrayDeque deque = new ArrayDeque();
            Reference reference = Reference.builder().protocolClass(protocolClass).referenceType(Reference.ReferenceType.CLASS).build();
            resolveClassFlow.process(reference);
            graph.addClass(reference);
            Arrays.stream(protocolClass.getDeclaredFields()).peek(f -> f.setAccessible(true)).forEach(deque::add);
            while (!deque.isEmpty()) {
                Reference s;
                Field field = (Field)deque.remove();
                if (Resolver.isData(field)) {
                    Reference r = Reference.builder().field(field).referenceType(Reference.ReferenceType.FIELD).build();
                    resolveFieldFlow.process(r);
                    graph.addReference(r);
                    continue;
                }
                if (Resolver.isClass(field)) {
                    if (graph.contains(field.getType())) {
                        Reference ref = graph.getReference(field.getType()).withField(field);
                        graph.addReference(ref);
                        continue;
                    }
                    s = Reference.builder().protocolClass(field.getType()).field(field).referenceType(Reference.ReferenceType.CLASS).build();
                    resolveClassFlow.process(s);
                    graph.addClass(s);
                    graph.addReference(s);
                    Arrays.stream(field.getType().getDeclaredFields()).peek(f -> f.setAccessible(true)).forEach(deque::add);
                    continue;
                }
                s = Reference.builder().field(field).referenceType(Reference.ReferenceType.INVALID).build();
                graph.addReference(s);
            }
            graph.adj.entrySet().stream().forEach(entry -> {
                Reference parent = (Reference)entry.getKey();
                ArrayList children = (ArrayList)entry.getValue();
                if (parent.decodingIgnore.booleanValue()) {
                    children.forEach(child -> {
                        child.decodingIgnore = true;
                    });
                }
                if (parent.encodingIgnore.booleanValue()) {
                    children.forEach(child -> {
                        child.encodingIgnore = true;
                    });
                }
            });
            List<Reference> refs = graph.getValidReferences();
            for (Reference r : refs) {
                hasLength = Arrays.stream(r.getDataTypeAnnotation().annotationType().getMethods()).anyMatch(m -> m.getName().equals("length") && m.getParameterCount() == 0);
                if (!hasLength) continue;
                String refNameLocal = null;
                try {
                    Method mRef = r.getDataTypeAnnotation().annotationType().getMethod("lengthRef", new Class[0]);
                    String value = (String)mRef.invoke((Object)r.getDataTypeAnnotation(), new Object[0]);
                    if (value != null && !value.isEmpty()) {
                        refNameLocal = value.startsWith("$") ? value.substring(1) : value;
                    }
                }
                catch (NoSuchMethodException mRef) {
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ResolvingException("Failed reading lengthRef attribute", e);
                }
                if (refNameLocal == null) continue;
                String refName = refNameLocal;
                Reference src = refs.stream().filter(x -> x.getField() != null).filter(x -> x.getField().getDeclaringClass() == r.getField().getDeclaringClass()).filter(x -> x.getField().getName().equals(refName)).findFirst().orElseThrow(() -> new ResolvingException(String.format("lengthRef source '%s' not found for %s", refName, r.getField())));
                if (refs.indexOf(src) >= refs.indexOf(r)) {
                    throw new ResolvingException(String.format("lengthRef source '%s' must be declared before %s", refName, r.getField()));
                }
                r.setLengthSupplier(() -> {
                    int len;
                    Object v = src.getValue().get();
                    if (v == null) {
                        len = 0;
                    } else if (v instanceof Number) {
                        len = ((Number)v).intValue();
                    } else {
                        throw new IllegalArgumentException("lengthRef source is not a Number");
                    }
                    return len;
                });
            }
            for (Reference r : refs) {
                if (!r.getField().isAnnotationPresent(AutoType.class) || !(hasLength = Arrays.stream(r.getDataTypeAnnotation().annotationType().getMethods()).anyMatch(m -> m.getName().equals("length") && m.getParameterCount() == 0))) continue;
                try {
                    r.getDataTypeAnnotation().annotationType().getMethod("length", new Class[0]).invoke((Object)r.getDataTypeAnnotation(), new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ResolvingException("Failed resolving @AutoType length", e);
                }
            }
            return graph;
        });
    }

    protected static boolean isClass(Field field) {
        return !IS_CLASS_CONDITION.or(f -> Modifier.isTransient(f.getModifiers())).or(f -> f.isEnumConstant() || Enum.class.isAssignableFrom(f.getType())).or(f -> EnumSet.class.isAssignableFrom(f.getType())).or(f -> f.getType().isArray()).or(f -> f.getType() == Class.class).or(f -> f.getType() == Object.class).or(f -> List.class.isAssignableFrom(f.getType())).or(f -> Map.class.isAssignableFrom(f.getType())).or(f -> Set.class.isAssignableFrom(f.getType())).test(field);
    }

    protected static boolean isData(Field field) {
        return IS_DATA_CONDITION.test(field);
    }
}

