/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.indunet.fastproto.annotation.Validator;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.ResolvingException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.graph.resolve.validate.TypeValidator;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.mapper.CodecMapper;
import org.indunet.fastproto.mapper.JavaTypeMapper;

public class CodecFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        boolean hasLength;
        Annotation original;
        Annotation decodeAnno = original = reference.getDataTypeAnnotation();
        Annotation encodeAnno = original;
        boolean bl = hasLength = original != null && Arrays.stream(original.annotationType().getMethods()).anyMatch(m -> m.getName().equals("length") && m.getParameterCount() == 0);
        if (hasLength) {
            Supplier<Integer> decodeLenSupplier = () -> {
                if (reference.getLengthSupplier() != null) {
                    return reference.getLengthSupplier().get();
                }
                try {
                    Integer l = (Integer)original.annotationType().getMethod("length", new Class[0]).invoke((Object)original, new Object[0]);
                    if (l != null && l == 0 && reference.getLengthSupplier() == null) {
                        throw new ResolvingException(String.format("Length is 0 and no lengthRef provided for %s", reference.getField()));
                    }
                    return l;
                }
                catch (ResolvingException re) {
                    throw re;
                }
                catch (Exception e) {
                    return 0;
                }
            };
            Supplier<Integer> encodeLenSupplier = () -> {
                boolean useSelf = false;
                try {
                    Method m = original.annotationType().getMethod("useSelfOnEncode", new Class[0]);
                    useSelf = (Boolean)m.invoke((Object)original, new Object[0]);
                }
                catch (Exception m) {
                    // empty catch block
                }
                if (useSelf) {
                    return CodecFlow.computeSelfLength(reference, reference.getValue().get());
                }
                if (reference.getLengthSupplier() != null) {
                    return reference.getLengthSupplier().get();
                }
                try {
                    return (Integer)original.annotationType().getMethod("length", new Class[0]).invoke((Object)original, new Object[0]);
                }
                catch (Exception e) {
                    return 0;
                }
            };
            decodeAnno = CodecFlow.wrapAnnotationWithDynamicLength(original, decodeLenSupplier);
            encodeAnno = CodecFlow.wrapAnnotationWithDynamicLength(original, encodeLenSupplier);
        }
        CodecContext decodeCtx = CodecContext.builder().dataTypeAnnotation(decodeAnno).fieldType(reference.getField().getType()).field(reference.getField()).defaultByteOrder(reference.getByteOrder()).defaultBitOrder(reference.getBitOrder()).build();
        CodecContext encodeCtx = CodecContext.builder().dataTypeAnnotation(encodeAnno).fieldType(reference.getField().getType()).field(reference.getField()).defaultByteOrder(reference.getByteOrder()).defaultBitOrder(reference.getBitOrder()).build();
        reference.setDecoder(this.resolveDecoder(reference, decodeCtx));
        reference.setEncoder(this.resolveEncoder(reference, encodeCtx));
        this.validateReference(reference);
        this.forward(reference);
    }

    protected Function<ByteBufferInputStream, ?> resolveDecoder(Reference reference, CodecContext context) {
        if (reference.getDecodingFormulaClass() != null) {
            return CodecMapper.getDecoder(context, reference.getDecodingFormulaClass());
        }
        if (reference.getDecodingLambda() != null) {
            Class javaType = JavaTypeMapper.get(reference.getDataTypeAnnotation().annotationType());
            Function<ByteBufferInputStream, ?> decoder = CodecMapper.getDefaultDecoder(context, javaType);
            return decoder.andThen(reference.getDecodingLambda());
        }
        return CodecMapper.getDecoder(context, null);
    }

    protected BiConsumer<ByteBufferOutputStream, Object> resolveEncoder(Reference reference, CodecContext context) {
        if (reference.getEncodingFormulaClass() != null) {
            return CodecMapper.getEncoder(context, reference.getEncodingFormulaClass());
        }
        if (reference.getEncodingLambda() != null) {
            Class javaType = JavaTypeMapper.get(reference.getDataTypeAnnotation().annotationType());
            BiConsumer<ByteBufferOutputStream, ? super Object> encoder = CodecMapper.getDefaultEncoder(context, javaType);
            Function func = reference.getEncodingLambda();
            return (outputStream, value) -> encoder.accept((ByteBufferOutputStream)outputStream, func.apply(value));
        }
        return CodecMapper.getEncoder(context, null);
    }

    protected void validateReference(Reference reference) {
        try {
            ValidatorContext ctx = ValidatorContext.builder().field(reference.getField()).typeAnnotation(reference.getDataTypeAnnotation()).protocolType(reference.getProtocolType()).decodingFormulaClass(reference.getDecodingFormulaClass()).encodingFormulaClass(reference.getEncodingFormulaClass()).build();
            Validator validator = reference.getDataTypeAnnotation().annotationType().getAnnotation(Validator.class);
            TypeValidator.create(validator.value()).process(ctx);
        }
        catch (ResolvingException e) {
            throw new ResolvingException(MessageFormat.format("Failed resolving the field of %s", reference.getField().toString()), e);
        }
    }

    private static Annotation wrapAnnotationWithDynamicLength(Annotation original, Supplier<Integer> lengthSupplier) {
        Class<? extends Annotation> at = original.annotationType();
        return (Annotation)Proxy.newProxyInstance(CodecFlow.class.getClassLoader(), new Class[]{at}, (proxy, method, args) -> {
            if (method.getName().equals("length") && method.getParameterCount() == 0) {
                return lengthSupplier.get();
            }
            return at.getMethod(method.getName(), method.getParameterTypes()).invoke((Object)original, args);
        });
    }

    private static int computeSelfLength(Reference r, Object value) {
        String annName;
        if (value == null) {
            return 0;
        }
        switch (annName = r.getDataTypeAnnotation().annotationType().getSimpleName()) {
            case "StringType": {
                try {
                    String cs = (String)r.getDataTypeAnnotation().annotationType().getMethod("charset", new Class[0]).invoke((Object)r.getDataTypeAnnotation(), new Object[0]);
                    return value.toString().getBytes(Charset.forName(cs)).length;
                }
                catch (Exception e) {
                    return value.toString().getBytes(Charset.forName("UTF-8")).length;
                }
            }
            case "BinaryType": {
                if (!(value instanceof byte[])) break;
                return ((byte[])value).length;
            }
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        return 0;
    }
}

