/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.AutoType;
import org.indunet.fastproto.annotation.DataType;
import org.indunet.fastproto.exception.ResolvingException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.mapper.AnnotationMapper;

public class TypeAnnotationFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Field field = reference.getField();
        Annotation typeAnnotation = this.findDataTypeAnnotation(field);
        if (typeAnnotation instanceof AutoType) {
            this.setAutoTypeAnnotation(reference, (AutoType)typeAnnotation);
        } else {
            this.setDataTypeAnnotation(reference, typeAnnotation);
        }
        reference.setReferenceType(Reference.ReferenceType.FIELD);
        this.forward(reference);
    }

    private Annotation findDataTypeAnnotation(Field field) {
        return Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(DataType.class)).findAny().orElseThrow(ResolvingException::new);
    }

    private void setAutoTypeAnnotation(Reference reference, AutoType autoType) {
        Class<? extends Annotation> type = AnnotationMapper.get(reference.getField().getGenericType());
        Annotation proxy = ProtocolType.proxy(autoType, type);
        reference.setDataTypeAnnotation(proxy);
        reference.setProtocolType(ProtocolType.proxy(proxy));
    }

    private void setDataTypeAnnotation(Reference reference, Annotation typeAnnotation) {
        reference.setDataTypeAnnotation(typeAnnotation);
        reference.setProtocolType(ProtocolType.proxy(typeAnnotation));
    }
}

