/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.io;

import java.math.BigInteger;
import java.util.stream.IntStream;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.io.ByteBuffer;
import org.indunet.fastproto.io.ByteBufferIOStream;

public final class ByteBufferInputStream
extends ByteBufferIOStream {
    public ByteBufferInputStream() {
        this(new ByteBuffer());
    }

    public ByteBufferInputStream(byte[] bytes) {
        this(new ByteBuffer(bytes));
    }

    public ByteBufferInputStream(ByteBuffer buffer) {
        super(buffer);
    }

    public boolean readBool(BitOrder order) {
        return this.readBool(this.byteIndex, this.bitIndex, order);
    }

    public boolean readBool(int byteOffset, int bitOffset, BitOrder order) {
        boolean value;
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Out of byte range.");
        }
        int bo = bitOffset;
        if (order == BitOrder.MSB_0) {
            bo = 7 - bitOffset;
        }
        boolean bl = value = (this.byteBuffer.get(byteOffset) & 1 << bo) != 0;
        if (bitOffset == 7) {
            this.byteIndex = byteOffset + 1;
            this.bitIndex = 0;
        } else {
            this.byteIndex = byteOffset;
            this.bitIndex = bitOffset + 1;
        }
        return value;
    }

    public byte readByte() {
        return this.readByte(this.byteIndex);
    }

    public byte readByte(int offset) {
        this.byteIndex = this.byteBuffer.reverse(offset) + 1;
        return this.byteBuffer.get(offset);
    }

    public short readShort(ByteOrder order) {
        return this.readShort(this.byteIndex, order);
    }

    public short readShort(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        short value = 0;
        if (order == ByteOrder.LITTLE) {
            value = (short)(value | this.byteBuffer.get(o) & 0xFF);
            value = (short)(value | this.byteBuffer.get(o + 1) << 8);
        } else if (order == ByteOrder.BIG) {
            value = (short)(value | this.byteBuffer.get(o) << 8);
            value = (short)(value | this.byteBuffer.get(o + 1) & 0xFF);
        }
        this.byteIndex = o + 2;
        return value;
    }

    public int readInt8() {
        return this.readInt8(this.byteIndex);
    }

    public int readInt8(int offset) {
        this.byteIndex = this.byteBuffer.reverse(offset) + 1;
        return this.byteBuffer.get(offset);
    }

    public int readInt16(ByteOrder order) {
        return this.readInt16(this.byteIndex, order);
    }

    public int readInt16(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        int value = 0;
        if (order == ByteOrder.BIG) {
            value = (short)(value | this.byteBuffer.get(o) << 8);
            value = (short)(value | this.byteBuffer.get(o + 1) & 0xFF);
        } else {
            value = (short)(value | this.byteBuffer.get(o) & 0xFF);
            value = (short)(value | this.byteBuffer.get(o + 1) << 8);
        }
        this.byteIndex = o + 2;
        return value;
    }

    public int readInt32(ByteOrder order) {
        return this.readInt32(this.byteIndex, order);
    }

    public int readInt32(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        int value = 0;
        if (order == ByteOrder.LITTLE) {
            value |= this.byteBuffer.get(o) & 0xFF;
            value |= (this.byteBuffer.get(o + 1) & 0xFF) << 8;
            value |= (this.byteBuffer.get(o + 2) & 0xFF) << 16;
            value |= (this.byteBuffer.get(o + 3) & 0xFF) << 24;
        } else if (order == ByteOrder.BIG) {
            value |= (this.byteBuffer.get(o) & 0xFF) << 24;
            value |= (this.byteBuffer.get(o + 1) & 0xFF) << 16;
            value |= (this.byteBuffer.get(o + 2) & 0xFF) << 8;
            value |= this.byteBuffer.get(o + 3) & 0xFF;
        }
        this.byteIndex = o + 4;
        return value;
    }

    public long readInt64(ByteOrder order) {
        return this.readInt64(this.byteIndex, order);
    }

    public long readInt64(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        long value = 0L;
        if (order == ByteOrder.LITTLE) {
            value |= (long)(this.byteBuffer.get(o) & 0xFF);
            value |= ((long)this.byteBuffer.get(o + 1) & 0xFFL) << 8;
            value |= ((long)this.byteBuffer.get(o + 2) & 0xFFL) << 16;
            value |= ((long)this.byteBuffer.get(o + 3) & 0xFFL) << 24;
            value |= ((long)this.byteBuffer.get(o + 4) & 0xFFL) << 32;
            value |= ((long)this.byteBuffer.get(o + 5) & 0xFFL) << 40;
            value |= ((long)this.byteBuffer.get(o + 6) & 0xFFL) << 48;
            value |= ((long)this.byteBuffer.get(o + 7) & 0xFFL) << 56;
        } else if (order == ByteOrder.BIG) {
            value |= ((long)this.byteBuffer.get(o) & 0xFFL) << 56;
            value |= ((long)this.byteBuffer.get(o + 1) & 0xFFL) << 48;
            value |= ((long)this.byteBuffer.get(o + 2) & 0xFFL) << 40;
            value |= ((long)this.byteBuffer.get(o + 3) & 0xFFL) << 32;
            value |= ((long)this.byteBuffer.get(o + 4) & 0xFFL) << 24;
            value |= ((long)this.byteBuffer.get(o + 5) & 0xFFL) << 16;
            value |= ((long)this.byteBuffer.get(o + 6) & 0xFFL) << 8;
            value |= (long)(this.byteBuffer.get(o + 7) & 0xFF);
        }
        this.byteIndex = o + 8;
        return value;
    }

    public int readUInt8() {
        return this.readUInt8(this.byteIndex++);
    }

    public int readUInt8(int offset) {
        this.byteIndex = this.byteBuffer.reverse(offset) + 1;
        return this.byteBuffer.get(offset) & 0xFF;
    }

    public int readUInt16(ByteOrder order) {
        return this.readUInt16(this.byteIndex, order);
    }

    public int readUInt16(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        this.byteIndex = o + 2;
        if (order == ByteOrder.BIG) {
            return (this.byteBuffer.get(o) & 0xFF) * 256 + (this.byteBuffer.get(o + 1) & 0xFF);
        }
        return (this.byteBuffer.get(o) & 0xFF) + (this.byteBuffer.get(o + 1) & 0xFF) * 256;
    }

    public long readUInt32(ByteOrder order) {
        return this.readUInt32(this.byteIndex, order);
    }

    public long readUInt32(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        long value = 0L;
        if (order == ByteOrder.LITTLE) {
            value |= (long)(this.byteBuffer.get(o) & 0xFF);
            value |= ((long)this.byteBuffer.get(o + 1) & 0xFFL) << 8;
            value |= ((long)this.byteBuffer.get(o + 2) & 0xFFL) << 16;
            value |= ((long)this.byteBuffer.get(o + 3) & 0xFFL) << 24;
        } else if (order == ByteOrder.BIG) {
            value |= ((long)this.byteBuffer.get(o) & 0xFFL) << 24;
            value |= ((long)this.byteBuffer.get(o + 1) & 0xFFL) << 16;
            value |= ((long)this.byteBuffer.get(o + 2) & 0xFFL) << 8;
            value |= (long)(this.byteBuffer.get(o + 3) & 0xFF);
        }
        this.byteIndex = o + 4;
        return value;
    }

    public BigInteger readUInt64(ByteOrder order) {
        return this.readUInt64(this.byteIndex, order);
    }

    public BigInteger readUInt64(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        long low = 0L;
        long high = 0L;
        if (order == ByteOrder.LITTLE) {
            low |= (long)(this.byteBuffer.get(o) & 0xFF);
            low |= ((long)this.byteBuffer.get(o + 1) & 0xFFL) << 8;
            low |= ((long)this.byteBuffer.get(o + 2) & 0xFFL) << 16;
            low |= ((long)this.byteBuffer.get(o + 3) & 0xFFL) << 24;
            high |= (long)this.byteBuffer.get(o + 4) & 0xFFL;
            high |= ((long)this.byteBuffer.get(o + 5) & 0xFFL) << 8;
            high |= ((long)this.byteBuffer.get(o + 6) & 0xFFL) << 16;
            high |= ((long)this.byteBuffer.get(o + 7) & 0xFFL) << 24;
        } else if (order == ByteOrder.BIG) {
            high |= ((long)this.byteBuffer.get(o) & 0xFFL) << 24;
            high |= ((long)this.byteBuffer.get(o + 1) & 0xFFL) << 16;
            high |= ((long)this.byteBuffer.get(o + 2) & 0xFFL) << 8;
            high |= (long)this.byteBuffer.get(o + 3) & 0xFFL;
            low |= ((long)this.byteBuffer.get(o + 4) & 0xFFL) << 24;
            low |= ((long)this.byteBuffer.get(o + 5) & 0xFFL) << 16;
            low |= ((long)this.byteBuffer.get(o + 6) & 0xFFL) << 8;
            low |= (long)(this.byteBuffer.get(o + 7) & 0xFF);
        }
        this.byteIndex = o + 8;
        return new BigInteger(String.valueOf(high)).multiply(new BigInteger(String.valueOf(0x100000000L))).add(new BigInteger(String.valueOf(low)));
    }

    public float readFloat(ByteOrder order) {
        return this.readFloat(this.byteIndex, order);
    }

    public float readFloat(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        int value = 0;
        if (order == ByteOrder.LITTLE) {
            value |= this.byteBuffer.get(o) & 0xFF;
            value |= (this.byteBuffer.get(o + 1) & 0xFF) << 8;
            value |= (this.byteBuffer.get(o + 2) & 0xFF) << 16;
            value |= (this.byteBuffer.get(o + 3) & 0xFF) << 24;
        } else if (order == ByteOrder.BIG) {
            value |= (this.byteBuffer.get(o) & 0xFF) << 24;
            value |= (this.byteBuffer.get(o + 1) & 0xFF) << 16;
            value |= (this.byteBuffer.get(o + 2) & 0xFF) << 8;
            value |= this.byteBuffer.get(o + 3) & 0xFF;
        }
        this.byteIndex = o + 4;
        return Float.intBitsToFloat(value);
    }

    public double readDouble(ByteOrder order) {
        return this.readDouble(this.byteIndex, order);
    }

    public double readDouble(int offset, ByteOrder order) {
        int o = this.byteBuffer.reverse(offset);
        long value = 0L;
        if (order == ByteOrder.LITTLE) {
            value |= (long)this.byteBuffer.get(o) & 0xFFL;
            value |= ((long)this.byteBuffer.get(o + 1) & 0xFFL) << 8;
            value |= ((long)this.byteBuffer.get(o + 2) & 0xFFL) << 16;
            value |= ((long)this.byteBuffer.get(o + 3) & 0xFFL) << 24;
            value |= ((long)this.byteBuffer.get(o + 4) & 0xFFL) << 32;
            value |= ((long)this.byteBuffer.get(o + 5) & 0xFFL) << 40;
            value |= ((long)this.byteBuffer.get(o + 6) & 0xFFL) << 48;
            value |= ((long)this.byteBuffer.get(o + 7) & 0xFFL) << 56;
        } else if (order == ByteOrder.BIG) {
            value |= ((long)this.byteBuffer.get(o) & 0xFFL) << 56;
            value |= ((long)this.byteBuffer.get(o + 1) & 0xFFL) << 48;
            value |= ((long)this.byteBuffer.get(o + 2) & 0xFFL) << 40;
            value |= ((long)this.byteBuffer.get(o + 3) & 0xFFL) << 32;
            value |= ((long)this.byteBuffer.get(o + 4) & 0xFFL) << 24;
            value |= ((long)this.byteBuffer.get(o + 5) & 0xFFL) << 16;
            value |= ((long)this.byteBuffer.get(o + 6) & 0xFFL) << 8;
            value |= (long)this.byteBuffer.get(o + 7) & 0xFFL;
        }
        this.byteIndex = o + 8;
        return Double.longBitsToDouble(value);
    }

    public byte[] readBytes(int length) {
        return this.readBytes(this.byteIndex, length);
    }

    public byte[] readBytes(int offset, int length) {
        int o = this.byteBuffer.reverse(offset);
        int l = this.byteBuffer.reverse(offset, length);
        byte[] bytes = new byte[l];
        IntStream.range(0, l).forEach(i -> {
            bytes[i] = this.byteBuffer.get(o + i);
        });
        this.byteIndex = o + l;
        return bytes;
    }
}

