/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.kafka;

import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.indunet.fastproto.FastProto;

public class FastProtoDeserializer<T>
implements Deserializer<T> {
    public static final String CONFIG_VALUE_TYPE = "fastproto.value.type";
    private Class<?> targetType;

    public void configure(Map<String, ?> configs, boolean isKey) {
        Object cls;
        Object v0 = cls = configs != null ? configs.get(CONFIG_VALUE_TYPE) : null;
        if (cls instanceof String) {
            try {
                this.targetType = Class.forName(cls);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class not found for fastproto.value.type: " + cls, e);
            }
        } else if (cls instanceof Class) {
            this.targetType = cls;
        }
    }

    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (this.targetType == null) {
            throw new IllegalStateException("fastproto.value.type must be configured for FastProtoDeserializer");
        }
        Object obj = FastProto.decode(data, this.targetType);
        return (T)obj;
    }

    public void close() {
    }
}

