/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.util;

import java.math.BigInteger;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt64Type;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.ReverseUtils;

public class EncodeUtils {
    public static void writeBool(byte[] bytes, int byteOffset, int bitOffset, boolean value) {
        EncodeUtils.writeBool(bytes, byteOffset, bitOffset, BitOrder.LSB_0, value);
    }

    public static void writeBool(byte[] bytes, int byteOffset, int bitOffset, BitOrder order, boolean value) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new EncodingException("Out of byte range.");
        }
        int o = ReverseUtils.reverse(bytes, byteOffset);
        if (order == BitOrder.MSB_0) {
            bitOffset = 7 - bitOffset;
        }
        if (value) {
            int n = o;
            bytes[n] = (byte)(bytes[n] | 1 << bitOffset);
        } else {
            int n = o;
            bytes[n] = (byte)(bytes[n] & ~(1 << bitOffset));
        }
    }

    public static void writeByte(byte[] bytes, int offset, byte value) {
        int o = ReverseUtils.reverse(bytes, offset);
        bytes[o] = value;
    }

    public static void writeShort(byte[] bytes, int offset, short value) {
        EncodeUtils.writeShort(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeShort(byte[] bytes, int offset, ByteOrder order, short value) {
        int o = ReverseUtils.reverse(bytes, offset);
        if (order == ByteOrder.LITTLE) {
            bytes[o] = (byte)value;
            bytes[o + 1] = (byte)(value >>> 8);
        } else if (order == ByteOrder.BIG) {
            bytes[o + 1] = (byte)value;
            bytes[o] = (byte)(value >>> 8);
        }
    }

    public static void writeInt8(byte[] bytes, int offset, int value) {
        if (value < -128 || value > 127) {
            throw new EncodingException("Out of int8 range.");
        }
        int o = ReverseUtils.reverse(bytes, offset);
        bytes[o] = (byte)value;
    }

    public static void writeInt16(byte[] bytes, int offset, int value) {
        EncodeUtils.writeInt16(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeInt16(byte[] bytes, int offset, ByteOrder order, int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new EncodingException("Out of int16 range.");
        }
        int o = ReverseUtils.reverse(bytes, offset);
        if (order == ByteOrder.BIG) {
            bytes[o + 1] = (byte)value;
            bytes[o] = (byte)(value >>> 8);
        } else {
            bytes[o] = (byte)value;
            bytes[o + 1] = (byte)(value >>> 8);
        }
    }

    public static void writeInt32(byte[] bytes, int offset, int value) {
        EncodeUtils.writeInt32(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeInt32(byte[] bytes, int offset, ByteOrder order, int value) {
        int o = ReverseUtils.reverse(bytes, offset);
        if (order == ByteOrder.LITTLE) {
            bytes[o] = (byte)value;
            bytes[o + 1] = (byte)(value >>> 8);
            bytes[o + 2] = (byte)(value >>> 16);
            bytes[o + 3] = (byte)(value >>> 24);
        } else if (order == ByteOrder.BIG) {
            bytes[o + 3] = (byte)value;
            bytes[o + 2] = (byte)(value >>> 8);
            bytes[o + 1] = (byte)(value >>> 16);
            bytes[o] = (byte)(value >>> 24);
        }
    }

    public static void writeInt64(byte[] bytes, int offset, long value) {
        EncodeUtils.writeInt64(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeInt64(byte[] bytes, int offset, ByteOrder order, long value) {
        int o = ReverseUtils.reverse(bytes, offset);
        if (order == ByteOrder.BIG) {
            bytes[o + 7] = (byte)value;
            bytes[o + 6] = (byte)(value >>> 8);
            bytes[o + 5] = (byte)(value >>> 16);
            bytes[o + 4] = (byte)(value >>> 24);
            bytes[o + 3] = (byte)(value >>> 32);
            bytes[o + 2] = (byte)(value >>> 40);
            bytes[o + 1] = (byte)(value >>> 48);
            bytes[o] = (byte)(value >>> 56);
        } else {
            bytes[o] = (byte)value;
            bytes[o + 1] = (byte)(value >>> 8);
            bytes[o + 2] = (byte)(value >>> 16);
            bytes[o + 3] = (byte)(value >>> 24);
            bytes[o + 4] = (byte)(value >>> 32);
            bytes[o + 5] = (byte)(value >>> 40);
            bytes[o + 6] = (byte)(value >>> 48);
            bytes[o + 7] = (byte)(value >>> 56);
        }
    }

    public static void writeUInt8(byte[] bytes, int offset, int value) {
        if (value < 0 || value > 255) {
            throw new EncodingException("Out of uint8 range.");
        }
        int o = ReverseUtils.reverse(bytes, offset);
        bytes[o] = (byte)value;
    }

    public static void writeUInt16(byte[] bytes, int offset, int value) {
        EncodeUtils.writeUInt16(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeUInt16(byte[] bytes, int offset, ByteOrder order, int value) {
        if (value < 0 || value > 65535) {
            throw new EncodingException("Out of uint16 range.");
        }
        int o = ReverseUtils.reverse(bytes, offset);
        if (order == ByteOrder.BIG) {
            bytes[o + 1] = (byte)value;
            bytes[o] = (byte)(value >>> 8);
        } else {
            bytes[o] = (byte)value;
            bytes[o + 1] = (byte)(value >>> 8);
        }
    }

    public static void writeUInt32(byte[] bytes, int offset, long value) {
        EncodeUtils.writeUInt32(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeUInt32(byte[] bytes, int offset, ByteOrder order, long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new EncodingException("Out of uint32 range.");
        }
        int o = ReverseUtils.reverse(bytes, offset);
        if (order == ByteOrder.BIG) {
            bytes[o + 3] = (byte)value;
            bytes[o + 2] = (byte)(value >>> 8);
            bytes[o + 1] = (byte)(value >>> 16);
            bytes[o] = (byte)(value >>> 24);
        } else {
            bytes[o] = (byte)value;
            bytes[o + 1] = (byte)(value >>> 8);
            bytes[o + 2] = (byte)(value >>> 16);
            bytes[o + 3] = (byte)(value >>> 24);
        }
    }

    public static void writeUInt64(byte[] bytes, int offset, BigInteger value) {
        EncodeUtils.writeUInt64(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeUInt64(byte[] bytes, int offset, ByteOrder order, BigInteger value) {
        if (value.compareTo(UInt64Type.MAX_VALUE) > 0 || value.compareTo(UInt64Type.MIN_VALUE) < 0) {
            throw new EncodingException("Out of uinteger64 range.");
        }
        int o = ReverseUtils.reverse(bytes, offset);
        long low = value.and(new BigInteger(String.valueOf(0xFFFFFFFFL))).longValueExact();
        long high = value.shiftRight(32).longValueExact();
        if (order == ByteOrder.BIG) {
            bytes[o + 7] = (byte)low;
            bytes[o + 6] = (byte)(low >>> 8);
            bytes[o + 5] = (byte)(low >>> 16);
            bytes[o + 4] = (byte)(low >>> 24);
            bytes[o + 3] = (byte)high;
            bytes[o + 2] = (byte)(high >>> 8);
            bytes[o + 1] = (byte)(high >>> 16);
            bytes[o] = (byte)(high >>> 24);
        } else {
            bytes[o] = (byte)low;
            bytes[o + 1] = (byte)(low >>> 8);
            bytes[o + 2] = (byte)(low >>> 16);
            bytes[o + 3] = (byte)(low >>> 24);
            bytes[o + 4] = (byte)high;
            bytes[o + 5] = (byte)(high >>> 8);
            bytes[o + 6] = (byte)(high >>> 16);
            bytes[o + 7] = (byte)(high >>> 24);
        }
    }

    public static void writeFloat(byte[] bytes, int offset, float value) {
        EncodeUtils.writeFloat(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeFloat(byte[] bytes, int offset, ByteOrder order, float value) {
        int o = ReverseUtils.reverse(bytes, offset);
        int bits = Float.floatToIntBits(value);
        if (order == ByteOrder.LITTLE) {
            bytes[o] = (byte)bits;
            bytes[o + 1] = (byte)(bits >>> 8);
            bytes[o + 2] = (byte)(bits >>> 16);
            bytes[o + 3] = (byte)(bits >>> 24);
        } else if (order == ByteOrder.BIG) {
            bytes[o + 3] = (byte)bits;
            bytes[o + 2] = (byte)(bits >>> 8);
            bytes[o + 1] = (byte)(bits >>> 16);
            bytes[o] = (byte)(bits >>> 24);
        }
    }

    public static void writeDouble(byte[] bytes, int offset, double value) {
        EncodeUtils.writeDouble(bytes, offset, ByteOrder.LITTLE, value);
    }

    public static void writeDouble(byte[] bytes, int offset, ByteOrder order, double value) {
        int o = ReverseUtils.reverse(bytes, offset);
        long bits = Double.doubleToRawLongBits(value);
        if (order == ByteOrder.BIG) {
            bytes[o + 7] = (byte)bits;
            bytes[o + 6] = (byte)(bits >>> 8);
            bytes[o + 5] = (byte)(bits >>> 16);
            bytes[o + 4] = (byte)(bits >>> 24);
            bytes[o + 3] = (byte)(bits >>> 32);
            bytes[o + 2] = (byte)(bits >>> 40);
            bytes[o + 1] = (byte)(bits >>> 48);
            bytes[o] = (byte)(bits >>> 56);
        } else {
            bytes[o] = (byte)bits;
            bytes[o + 1] = (byte)(bits >>> 8);
            bytes[o + 2] = (byte)(bits >>> 16);
            bytes[o + 3] = (byte)(bits >>> 24);
            bytes[o + 4] = (byte)(bits >>> 32);
            bytes[o + 5] = (byte)(bits >>> 40);
            bytes[o + 6] = (byte)(bits >>> 48);
            bytes[o + 7] = (byte)(bits >>> 56);
        }
    }

    public static void writeBytes(byte[] bytes, int offset, byte[] values) {
        int o = ReverseUtils.reverse(bytes, offset);
        if (o + values.length > bytes.length) {
            throw new EncodingException("Out of the bytes range.");
        }
        System.arraycopy(values, 0, bytes, o, values.length);
    }
}

