/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.checksum.Checker;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.ReverseUtils;

public class Crc8Checker
implements Checker {
    protected static final Map<Integer, Crc8Checker> checkers = new ConcurrentHashMap<Integer, Crc8Checker>();
    protected static final int defaultPoly = 213;
    protected int poly;

    protected Crc8Checker(int poly) {
        this.poly = poly;
    }

    public static Crc8Checker getInstance() {
        return checkers.computeIfAbsent(213, p -> new Crc8Checker((int)p));
    }

    public static synchronized Crc8Checker getInstance(int poly) {
        if (poly == 0) {
            return Crc8Checker.getInstance();
        }
        return checkers.computeIfAbsent(poly, p -> new Crc8Checker(poly));
    }

    @Override
    public boolean validate(byte[] datagram, Class<?> protocolClass) {
        int expected;
        int length;
        if (!protocolClass.isAnnotationPresent(EnableChecksum.class)) {
            return true;
        }
        EnableChecksum checkSum = protocolClass.getAnnotation(EnableChecksum.class);
        int byteOffset = checkSum.value();
        int start = checkSum.start();
        int actual = this.getValue(datagram, start, length = checkSum.length());
        return actual == (expected = CodecUtils.uinteger8Type(datagram, ReverseUtils.offset(datagram.length, byteOffset)));
    }

    @Override
    public void setValue(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(EnableChecksum.class)) {
            return;
        }
        EnableChecksum checkSum = protocolClass.getAnnotation(EnableChecksum.class);
        int byteOffset = checkSum.value();
        int start = checkSum.start();
        int length = checkSum.length();
        this.setValue(datagram, start, byteOffset, length);
    }

    @Override
    public int getSize() {
        return 1;
    }

    public void setValue(byte[] datagram, int byteOffset, int start, int length) {
        int value = this.getValue(datagram, start, length);
        CodecUtils.uinteger8Type(datagram, byteOffset, value);
    }

    public int getValue(byte[] datagram, int start, int length) {
        int s = ReverseUtils.offset(datagram.length, start);
        int l = ReverseUtils.length(datagram.length, start, length);
        if (s < 0) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (l <= 0) {
            throw new DecodingException(CodecError.ILLEGAL_PARAMETER);
        }
        if (s + length > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        int crc8 = 0;
        for (int i = 0; i < l; ++i) {
            crc8 = (byte)(crc8 ^ datagram[s + i]);
            for (int j = 0; j < 8; ++j) {
                if ((crc8 & 0x80) != 0) {
                    crc8 = (byte)(crc8 << 1);
                    crc8 = (byte)(crc8 ^ this.poly);
                    continue;
                }
                crc8 = (byte)(crc8 << 1);
            }
        }
        return crc8 & 0xFF;
    }

    public int getPoly() {
        return this.poly;
    }
}

