/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.Int32Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class IntegerDecoder
implements TypeDecoder<Integer> {
    @Override
    public Integer decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Int32Type type = context.getTypeAnnotation(Int32Type.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public int decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy endian) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        try {
            return CodecUtils.integerType(datagram, byteOffset, endian);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding integer type.", (Throwable)e);
        }
    }
}

