/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.ArrayType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.exception.SpaceNotEnoughException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.ReverseUtils;
import org.indunet.fastproto.util.TypeUtils;

public class ArrayEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        ArrayType type = context.getTypeAnnotation(ArrayType.class);
        this.encode(context.getDatagram(), type.value(), type.length(), type.genericType(), context.getEndianPolicy(), context.getValue());
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull Class<? extends Annotation> type, @NonNull EndianPolicy policy, Object values) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int size = TypeUtils.size(type);
        int bo = ReverseUtils.offset(datagram.length, byteOffset);
        boolean primitive = values.getClass().getComponentType().isPrimitive();
        if (bo < 0) {
            throw new EncodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new EncodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (length <= 0) {
            throw new EncodingException(CodecError.ILLEGAL_PARAMETER);
        }
        if (bo + size * length > datagram.length) {
            throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        Consumer<BiConsumer> codec = consumer -> IntStream.range(0, length).parallel().forEach(i -> consumer.accept(i * size + byteOffset, i));
        if (type == ProtocolType.CHAR) {
            codec.accept((b, i) -> CodecUtils.type(datagram, (int)b, policy, primitive ? ((char[])values)[i] : ((Character[])values)[i].charValue()));
        } else if (type == ProtocolType.BYTE) {
            codec.accept((b, i) -> CodecUtils.type(datagram, (int)b, policy, primitive ? (short)((byte[])values)[i] : (short)((Byte[])values)[i].byteValue()));
        } else if (type == ProtocolType.SHORT) {
            codec.accept((b, i) -> CodecUtils.type(datagram, (int)b, policy, primitive ? ((short[])values)[i] : ((Short[])values)[i]));
        } else if (type == ProtocolType.INT32) {
            codec.accept((b, i) -> CodecUtils.type(datagram, (int)b, policy, primitive ? ((int[])values)[i] : ((Integer[])values)[i]));
        } else if (type == ProtocolType.LONG) {
            codec.accept((b, i) -> CodecUtils.type(datagram, (int)b, policy, primitive ? ((long[])values)[i] : ((Long[])values)[i]));
        } else if (type == ProtocolType.UINT8) {
            codec.accept((b, i) -> CodecUtils.uinteger8Type(datagram, b, primitive ? ((int[])values)[i] : ((Integer[])values)[i]));
        } else if (type == ProtocolType.UINT16) {
            codec.accept((b, i) -> CodecUtils.uinteger16Type(datagram, b, policy, primitive ? ((int[])values)[i] : ((Integer[])values)[i]));
        } else if (type == ProtocolType.UINT32) {
            codec.accept((b, i) -> CodecUtils.uinteger32Type(datagram, b, policy, primitive ? ((long[])values)[i] : ((Long[])values)[i]));
        } else if (type == ProtocolType.INT8) {
            codec.accept((b, i) -> CodecUtils.integer8Type(datagram, b, primitive ? ((int[])values)[i] : ((Integer[])values)[i]));
        } else if (type == ProtocolType.INT16) {
            codec.accept((b, i) -> CodecUtils.integer16Type(datagram, b, policy, primitive ? ((int[])values)[i] : ((Integer[])values)[i]));
        } else if (type == ProtocolType.FLOAT) {
            codec.accept((b, i) -> CodecUtils.type(datagram, (int)b, policy, primitive ? ((float[])values)[i] : ((Float[])values)[i].floatValue()));
        } else if (type == ProtocolType.DOUBLE) {
            codec.accept((b, i) -> CodecUtils.type(datagram, (int)b, policy, primitive ? ((double[])values)[i] : ((Double[])values)[i]));
        } else {
            throw new EncodingException(MessageFormat.format(CodecError.NOT_SUPPORT_ARRAY_TYPE.getMessage(), type.toString()));
        }
    }
}

