/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.CharType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class CharacterEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        CharType type = context.getTypeAnnotation(CharType.class);
        Character value = context.getValue(Character.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(context.getDatagram(), type.value(), policy, value.charValue());
    }

    public void encode(byte[] datagram, int offset, EndianPolicy policy, char value) {
        try {
            CodecUtils.characterType(datagram, offset, policy, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the character type.", (Throwable)e);
        }
    }
}

