/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.util.Arrays;
import org.indunet.fastproto.annotation.EnableVersion;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;

public class EnableVersionFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Class<?> protocolClass = reference.getProtocolClass();
        if (protocolClass.isAnnotationPresent(EnableVersion.class)) {
            EnableVersion enableVersion = protocolClass.getAnnotation(EnableVersion.class);
            if (Arrays.stream(EnableVersion.PROTOCOL_TYPES).anyMatch(t -> t == enableVersion.genericType())) {
                reference.setEnableVersion(enableVersion);
            } else {
                throw new ResolveException(String.format("Illegal protocol type for @EnableVersion of %s", protocolClass.getName()));
            }
        }
        this.forward(reference);
    }
}

