/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import lombok.NonNull;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.ProtocolVersionException;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.util.VersionUtils;

public class VerifyVersionFlow
extends Pipeline<CodecContext> {
    @Override
    public void process(@NonNull CodecContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (!VersionUtils.validate(context.getDatagram(), context.getReferenceGraph().root())) {
            throw new ProtocolVersionException(CodecError.PROTOCOL_VERSION_NOT_MATCH);
        }
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 16L;
    }
}

