/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import org.indunet.fastproto.graph.Reference;

public final class CodecFeature {
    public static final long DEFAULT = 0L;
    public static final long DISABLE_COMPRESS = 260L;
    public static final long DISABLE_PROTOCOL_VERSION = 16400L;
    public static final long DISABLE_CHECKSUM = 8200L;
    public static final long NON_INFER_LENGTH = 4096L;
    public static final long DISABLE_CRYPTO = 1026L;
    public static final long DISABLE_FIXED_LENGTH = 2080L;

    public static long of(Reference reference) {
        long codecFeature = 0L;
        if (reference.getEnableCrypto() == null) {
            codecFeature |= 0x402L;
        }
        if (reference.getEnableCompress() == null) {
            codecFeature |= 0x104L;
        }
        if (reference.getEnableChecksum() == null) {
            codecFeature |= 0x2008L;
        }
        if (reference.getEnableProtocolVersions().isEmpty()) {
            codecFeature |= 0x4010L;
        }
        if (reference.getEnableFixedLength() == null) {
            codecFeature |= 0x820L;
        }
        return codecFeature;
    }

    public static long of(long ... codecFeatures) {
        long codecFeature = 0L;
        for (long feature : codecFeatures) {
            codecFeature |= feature;
        }
        return codecFeature;
    }
}

