/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.compress;

import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.indunet.fastproto.compress.Compressor;

public class Lz4Compressor
implements Compressor {
    @Override
    public byte[] compress(byte[] bytes) {
        LZ4Factory lz4Factory = LZ4Factory.safeInstance();
        LZ4Compressor fastCompressor = lz4Factory.fastCompressor();
        int maxCompressedLength = fastCompressor.maxCompressedLength(bytes.length);
        byte[] cache = new byte[maxCompressedLength];
        int compressedLength = fastCompressor.compress(bytes, 0, bytes.length, cache, 0, maxCompressedLength);
        return Arrays.copyOf(cache, compressedLength);
    }

    @Override
    public byte[] uncompress(byte[] bytes) {
        LZ4Factory lz4Factory = LZ4Factory.safeInstance();
        LZ4SafeDecompressor decompressor2 = lz4Factory.safeDecompressor();
        byte[] cache = new byte[bytes.length * 4];
        int decompressedLength = decompressor2.decompress(bytes, 0, bytes.length, cache, 0);
        return Arrays.copyOf(cache, decompressedLength);
    }
}

