/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class FloatEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        FloatType type = context.getTypeAnnotation(FloatType.class);
        Float value = context.getValue(Float.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value.floatValue());
    }

    public void encode(byte[] datagram, int offset, EndianPolicy policy, float value) {
        try {
            CodecUtils.floatType(datagram, offset, policy, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the float type.", (Throwable)e);
        }
    }
}

