/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.nio.charset.Charset;
import lombok.NonNull;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class StringEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        StringType dataType = context.getTypeAnnotation(StringType.class);
        String value = context.getValue(String.class);
        this.encode(context.getDatagram(), dataType.value(), dataType.length(), Charset.defaultCharset(), value);
    }

    public void encode(@NonNull byte[] datagram, int offset, int length, @NonNull Charset set, @NonNull String value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (set == null) {
            throw new NullPointerException("set is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            CodecUtils.binaryType(datagram, offset, length, value.getBytes());
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the string type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException("Fail encoding the string type.", (Throwable)e);
        }
    }
}

