/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.TimeType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.ReverseUtils;

public class TimestampEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        EndianPolicy policy = context.getEndianPolicy();
        TimeType type = context.getTypeAnnotation(TimeType.class);
        Date value = context.getValue(Date.class);
        this.encode(context.getDatagram(), type.value(), type.genericType(), policy, type.unit(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, @NonNull Class<? extends Annotation> type, @NonNull EndianPolicy policy, @NonNull TimeUnit unit, @NonNull Date value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        int bo = ReverseUtils.offset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new EncodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (type == ProtocolType.LONG && unit == TimeUnit.MILLISECONDS) {
            if (bo + 8 > datagram.length) {
                throw new EncodingException(CodecError.EXCEEDED_DATAGRAM_SIZE);
            }
            CodecUtils.int64Type(datagram, bo, policy, value.getTime());
        } else if (type == ProtocolType.UINT32 && unit == TimeUnit.SECONDS) {
            if (bo + 4 > datagram.length) {
                throw new EncodingException(CodecError.EXCEEDED_DATAGRAM_SIZE);
            }
            CodecUtils.int32Type(datagram, bo, policy, (int)(value.getTime() / 1000L));
        } else {
            throw new EncodingException(CodecError.ILLEGAL_TIMESTAMP_PARAMETERS);
        }
    }
}

