/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.annotation.EnableCompress;
import org.indunet.fastproto.annotation.EnableCrypto;
import org.indunet.fastproto.annotation.EnableFixedLength;
import org.indunet.fastproto.annotation.EnableProtocolVersion;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;

public class Reference {
    ReferenceType referenceType;
    EndianPolicy endianPolicy;
    Boolean decodingIgnore;
    Boolean encodingIgnore;
    Class<?> protocolClass;
    ConstructorType constructorType;
    EnableCompress enableCompress;
    List<EnableProtocolVersion> enableProtocolVersions;
    EnableChecksum enableChecksum;
    EnableCrypto enableCrypto;
    EnableFixedLength enableFixedLength;
    Field field;
    Annotation typeAnnotation;
    ProtocolType protocolType;
    Class<? extends TypeDecoder> decoderClass;
    Class<? extends TypeEncoder> encoderClass;
    Class<? extends Function> decodeFormula;
    Class<? extends Function> encodeFormula;
    Function<DecodeContext, ?> decoder;
    Consumer<?> encoder;
    Integer byteOffset;
    Integer bitOffset;
    Integer size;
    Integer length;
    ThreadLocal<Object> value;

    public Object newInstance() {
        try {
            Object object = this.protocolClass.newInstance();
            this.value.set(object);
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DecodingException(String.format("Fail decoding the class %s", this.protocolClass.getName()), (Throwable)e);
        }
    }

    public Object newInstance(Reference[] references) {
        Class[] types = (Class[])Arrays.stream(references).filter(r -> r.getReferenceType() != ReferenceType.INVALID).map(Reference::getField).map(Field::getType).toArray(Class[]::new);
        try {
            Constructor<?> constructor = this.protocolClass.getConstructor(types);
            Object[] args = Arrays.stream(references).filter(r -> r.getReferenceType() != ReferenceType.INVALID).map(r -> r.getValue().get()).toArray();
            Object object = constructor.newInstance(args);
            this.value.set(object);
            return object;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new DecodingException(String.format("Fail decoding the class %s", this.protocolClass.getName()), (Throwable)e);
        }
    }

    public void setField(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        Field field = reference.getField();
        if (this.value.get() != null) {
            try {
                field.set(this.value.get(), reference.getValue().get());
            }
            catch (IllegalAccessException e) {
                throw new DecodingException(String.format("Fail decoding the field %s of class %s", field.toString(), this.protocolClass.getName()), (Throwable)e);
            }
        }
    }

    public Object getValue(Object object) {
        try {
            if (object == null) {
                return null;
            }
            if (this.field == null) {
                return object;
            }
            return this.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new EncodingException(String.format("Fail decoding the field %s of class %s", this.field.toString(), this.protocolClass.getName()), (Throwable)e);
        }
    }

    public void clear() {
        this.value.remove();
    }

    public void setValue(Object value) {
        this.value.set(value);
    }

    public boolean equals(Object other) {
        if (other instanceof Reference && this.referenceType == ReferenceType.CLASS && ((Reference)other).referenceType == ReferenceType.CLASS) {
            return this.protocolClass == ((Reference)other).protocolClass;
        }
        return super.equals(other);
    }

    public int hashCode() {
        if (this.referenceType == ReferenceType.CLASS) {
            return this.protocolClass.hashCode();
        }
        return super.hashCode();
    }

    private static Boolean $default$decodingIgnore() {
        return false;
    }

    private static Boolean $default$encodingIgnore() {
        return false;
    }

    private static ThreadLocal<Object> $default$value() {
        return new ThreadLocal<Object>();
    }

    public static ReferenceBuilder builder() {
        return new ReferenceBuilder();
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public EndianPolicy getEndianPolicy() {
        return this.endianPolicy;
    }

    public Boolean getDecodingIgnore() {
        return this.decodingIgnore;
    }

    public Boolean getEncodingIgnore() {
        return this.encodingIgnore;
    }

    public Class<?> getProtocolClass() {
        return this.protocolClass;
    }

    public ConstructorType getConstructorType() {
        return this.constructorType;
    }

    public EnableCompress getEnableCompress() {
        return this.enableCompress;
    }

    public List<EnableProtocolVersion> getEnableProtocolVersions() {
        return this.enableProtocolVersions;
    }

    public EnableChecksum getEnableChecksum() {
        return this.enableChecksum;
    }

    public EnableCrypto getEnableCrypto() {
        return this.enableCrypto;
    }

    public EnableFixedLength getEnableFixedLength() {
        return this.enableFixedLength;
    }

    public Field getField() {
        return this.field;
    }

    public Annotation getTypeAnnotation() {
        return this.typeAnnotation;
    }

    public ProtocolType getProtocolType() {
        return this.protocolType;
    }

    public Class<? extends TypeDecoder> getDecoderClass() {
        return this.decoderClass;
    }

    public Class<? extends TypeEncoder> getEncoderClass() {
        return this.encoderClass;
    }

    public Class<? extends Function> getDecodeFormula() {
        return this.decodeFormula;
    }

    public Class<? extends Function> getEncodeFormula() {
        return this.encodeFormula;
    }

    public Function<DecodeContext, ?> getDecoder() {
        return this.decoder;
    }

    public Consumer<?> getEncoder() {
        return this.encoder;
    }

    public Integer getByteOffset() {
        return this.byteOffset;
    }

    public Integer getBitOffset() {
        return this.bitOffset;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getLength() {
        return this.length;
    }

    public ThreadLocal<Object> getValue() {
        return this.value;
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setEndianPolicy(EndianPolicy endianPolicy) {
        this.endianPolicy = endianPolicy;
    }

    public void setDecodingIgnore(Boolean decodingIgnore) {
        this.decodingIgnore = decodingIgnore;
    }

    public void setEncodingIgnore(Boolean encodingIgnore) {
        this.encodingIgnore = encodingIgnore;
    }

    public void setProtocolClass(Class<?> protocolClass) {
        this.protocolClass = protocolClass;
    }

    public void setConstructorType(ConstructorType constructorType) {
        this.constructorType = constructorType;
    }

    public void setEnableCompress(EnableCompress enableCompress) {
        this.enableCompress = enableCompress;
    }

    public void setEnableProtocolVersions(List<EnableProtocolVersion> enableProtocolVersions) {
        this.enableProtocolVersions = enableProtocolVersions;
    }

    public void setEnableChecksum(EnableChecksum enableChecksum) {
        this.enableChecksum = enableChecksum;
    }

    public void setEnableCrypto(EnableCrypto enableCrypto) {
        this.enableCrypto = enableCrypto;
    }

    public void setEnableFixedLength(EnableFixedLength enableFixedLength) {
        this.enableFixedLength = enableFixedLength;
    }

    public void setTypeAnnotation(Annotation typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public void setProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    public void setDecoderClass(Class<? extends TypeDecoder> decoderClass) {
        this.decoderClass = decoderClass;
    }

    public void setEncoderClass(Class<? extends TypeEncoder> encoderClass) {
        this.encoderClass = encoderClass;
    }

    public void setDecodeFormula(Class<? extends Function> decodeFormula) {
        this.decodeFormula = decodeFormula;
    }

    public void setEncodeFormula(Class<? extends Function> encodeFormula) {
        this.encodeFormula = encodeFormula;
    }

    public void setDecoder(Function<DecodeContext, ?> decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(Consumer<?> encoder) {
        this.encoder = encoder;
    }

    public void setByteOffset(Integer byteOffset) {
        this.byteOffset = byteOffset;
    }

    public void setBitOffset(Integer bitOffset) {
        this.bitOffset = bitOffset;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String toString() {
        return "Reference(referenceType=" + (Object)((Object)this.getReferenceType()) + ", endianPolicy=" + (Object)((Object)this.getEndianPolicy()) + ", decodingIgnore=" + this.getDecodingIgnore() + ", encodingIgnore=" + this.getEncodingIgnore() + ", protocolClass=" + this.getProtocolClass() + ", constructorType=" + (Object)((Object)this.getConstructorType()) + ", enableCompress=" + this.getEnableCompress() + ", enableProtocolVersions=" + this.getEnableProtocolVersions() + ", enableChecksum=" + this.getEnableChecksum() + ", enableCrypto=" + this.getEnableCrypto() + ", enableFixedLength=" + this.getEnableFixedLength() + ", field=" + this.getField() + ", typeAnnotation=" + this.getTypeAnnotation() + ", protocolType=" + this.getProtocolType() + ", decoderClass=" + this.getDecoderClass() + ", encoderClass=" + this.getEncoderClass() + ", decodeFormula=" + this.getDecodeFormula() + ", encodeFormula=" + this.getEncodeFormula() + ", decoder=" + this.getDecoder() + ", encoder=" + this.getEncoder() + ", byteOffset=" + this.getByteOffset() + ", bitOffset=" + this.getBitOffset() + ", size=" + this.getSize() + ", length=" + this.getLength() + ", value=" + this.getValue() + ")";
    }

    public Reference() {
        this.decodingIgnore = Reference.$default$decodingIgnore();
        this.encodingIgnore = Reference.$default$encodingIgnore();
        this.value = Reference.$default$value();
    }

    public Reference(ReferenceType referenceType, EndianPolicy endianPolicy, Boolean decodingIgnore, Boolean encodingIgnore, Class<?> protocolClass, ConstructorType constructorType, EnableCompress enableCompress, List<EnableProtocolVersion> enableProtocolVersions, EnableChecksum enableChecksum, EnableCrypto enableCrypto, EnableFixedLength enableFixedLength, Field field, Annotation typeAnnotation, ProtocolType protocolType, Class<? extends TypeDecoder> decoderClass, Class<? extends TypeEncoder> encoderClass, Class<? extends Function> decodeFormula, Class<? extends Function> encodeFormula, Function<DecodeContext, ?> decoder, Consumer<?> encoder, Integer byteOffset, Integer bitOffset, Integer size, Integer length, ThreadLocal<Object> value) {
        this.referenceType = referenceType;
        this.endianPolicy = endianPolicy;
        this.decodingIgnore = decodingIgnore;
        this.encodingIgnore = encodingIgnore;
        this.protocolClass = protocolClass;
        this.constructorType = constructorType;
        this.enableCompress = enableCompress;
        this.enableProtocolVersions = enableProtocolVersions;
        this.enableChecksum = enableChecksum;
        this.enableCrypto = enableCrypto;
        this.enableFixedLength = enableFixedLength;
        this.field = field;
        this.typeAnnotation = typeAnnotation;
        this.protocolType = protocolType;
        this.decoderClass = decoderClass;
        this.encoderClass = encoderClass;
        this.decodeFormula = decodeFormula;
        this.encodeFormula = encodeFormula;
        this.decoder = decoder;
        this.encoder = encoder;
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.size = size;
        this.length = length;
        this.value = value;
    }

    public Reference withReferenceType(ReferenceType referenceType) {
        return this.referenceType == referenceType ? this : new Reference(referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEndianPolicy(EndianPolicy endianPolicy) {
        return this.endianPolicy == endianPolicy ? this : new Reference(this.referenceType, endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecodingIgnore(Boolean decodingIgnore) {
        return this.decodingIgnore == decodingIgnore ? this : new Reference(this.referenceType, this.endianPolicy, decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncodingIgnore(Boolean encodingIgnore) {
        return this.encodingIgnore == encodingIgnore ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withProtocolClass(Class<?> protocolClass) {
        return this.protocolClass == protocolClass ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withConstructorType(ConstructorType constructorType) {
        return this.constructorType == constructorType ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEnableCompress(EnableCompress enableCompress) {
        return this.enableCompress == enableCompress ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEnableProtocolVersions(List<EnableProtocolVersion> enableProtocolVersions) {
        return this.enableProtocolVersions == enableProtocolVersions ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEnableChecksum(EnableChecksum enableChecksum) {
        return this.enableChecksum == enableChecksum ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEnableCrypto(EnableCrypto enableCrypto) {
        return this.enableCrypto == enableCrypto ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEnableFixedLength(EnableFixedLength enableFixedLength) {
        return this.enableFixedLength == enableFixedLength ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withField(Field field) {
        return this.field == field ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withTypeAnnotation(Annotation typeAnnotation) {
        return this.typeAnnotation == typeAnnotation ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withProtocolType(ProtocolType protocolType) {
        return this.protocolType == protocolType ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecoderClass(Class<? extends TypeDecoder> decoderClass) {
        return this.decoderClass == decoderClass ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncoderClass(Class<? extends TypeEncoder> encoderClass) {
        return this.encoderClass == encoderClass ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecodeFormula(Class<? extends Function> decodeFormula) {
        return this.decodeFormula == decodeFormula ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncodeFormula(Class<? extends Function> encodeFormula) {
        return this.encodeFormula == encodeFormula ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withDecoder(Function<DecodeContext, ?> decoder) {
        return this.decoder == decoder ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withEncoder(Consumer<?> encoder) {
        return this.encoder == encoder ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, encoder, this.byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withByteOffset(Integer byteOffset) {
        return this.byteOffset == byteOffset ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, byteOffset, this.bitOffset, this.size, this.length, this.value);
    }

    public Reference withBitOffset(Integer bitOffset) {
        return this.bitOffset == bitOffset ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, bitOffset, this.size, this.length, this.value);
    }

    public Reference withSize(Integer size) {
        return this.size == size ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, size, this.length, this.value);
    }

    public Reference withLength(Integer length) {
        return this.length == length ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, length, this.value);
    }

    public Reference withValue(ThreadLocal<Object> value) {
        return this.value == value ? this : new Reference(this.referenceType, this.endianPolicy, this.decodingIgnore, this.encodingIgnore, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, value);
    }

    public static class ReferenceBuilder {
        private ReferenceType referenceType;
        private EndianPolicy endianPolicy;
        private boolean decodingIgnore$set;
        private Boolean decodingIgnore$value;
        private boolean encodingIgnore$set;
        private Boolean encodingIgnore$value;
        private Class<?> protocolClass;
        private ConstructorType constructorType;
        private EnableCompress enableCompress;
        private List<EnableProtocolVersion> enableProtocolVersions;
        private EnableChecksum enableChecksum;
        private EnableCrypto enableCrypto;
        private EnableFixedLength enableFixedLength;
        private Field field;
        private Annotation typeAnnotation;
        private ProtocolType protocolType;
        private Class<? extends TypeDecoder> decoderClass;
        private Class<? extends TypeEncoder> encoderClass;
        private Class<? extends Function> decodeFormula;
        private Class<? extends Function> encodeFormula;
        private Function<DecodeContext, ?> decoder;
        private Consumer<?> encoder;
        private Integer byteOffset;
        private Integer bitOffset;
        private Integer size;
        private Integer length;
        private boolean value$set;
        private ThreadLocal<Object> value$value;

        ReferenceBuilder() {
        }

        public ReferenceBuilder referenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public ReferenceBuilder endianPolicy(EndianPolicy endianPolicy) {
            this.endianPolicy = endianPolicy;
            return this;
        }

        public ReferenceBuilder decodingIgnore(Boolean decodingIgnore) {
            this.decodingIgnore$value = decodingIgnore;
            this.decodingIgnore$set = true;
            return this;
        }

        public ReferenceBuilder encodingIgnore(Boolean encodingIgnore) {
            this.encodingIgnore$value = encodingIgnore;
            this.encodingIgnore$set = true;
            return this;
        }

        public ReferenceBuilder protocolClass(Class<?> protocolClass) {
            this.protocolClass = protocolClass;
            return this;
        }

        public ReferenceBuilder constructorType(ConstructorType constructorType) {
            this.constructorType = constructorType;
            return this;
        }

        public ReferenceBuilder enableCompress(EnableCompress enableCompress) {
            this.enableCompress = enableCompress;
            return this;
        }

        public ReferenceBuilder enableProtocolVersions(List<EnableProtocolVersion> enableProtocolVersions) {
            this.enableProtocolVersions = enableProtocolVersions;
            return this;
        }

        public ReferenceBuilder enableChecksum(EnableChecksum enableChecksum) {
            this.enableChecksum = enableChecksum;
            return this;
        }

        public ReferenceBuilder enableCrypto(EnableCrypto enableCrypto) {
            this.enableCrypto = enableCrypto;
            return this;
        }

        public ReferenceBuilder enableFixedLength(EnableFixedLength enableFixedLength) {
            this.enableFixedLength = enableFixedLength;
            return this;
        }

        public ReferenceBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public ReferenceBuilder typeAnnotation(Annotation typeAnnotation) {
            this.typeAnnotation = typeAnnotation;
            return this;
        }

        public ReferenceBuilder protocolType(ProtocolType protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public ReferenceBuilder decoderClass(Class<? extends TypeDecoder> decoderClass) {
            this.decoderClass = decoderClass;
            return this;
        }

        public ReferenceBuilder encoderClass(Class<? extends TypeEncoder> encoderClass) {
            this.encoderClass = encoderClass;
            return this;
        }

        public ReferenceBuilder decodeFormula(Class<? extends Function> decodeFormula) {
            this.decodeFormula = decodeFormula;
            return this;
        }

        public ReferenceBuilder encodeFormula(Class<? extends Function> encodeFormula) {
            this.encodeFormula = encodeFormula;
            return this;
        }

        public ReferenceBuilder decoder(Function<DecodeContext, ?> decoder) {
            this.decoder = decoder;
            return this;
        }

        public ReferenceBuilder encoder(Consumer<?> encoder) {
            this.encoder = encoder;
            return this;
        }

        public ReferenceBuilder byteOffset(Integer byteOffset) {
            this.byteOffset = byteOffset;
            return this;
        }

        public ReferenceBuilder bitOffset(Integer bitOffset) {
            this.bitOffset = bitOffset;
            return this;
        }

        public ReferenceBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public ReferenceBuilder length(Integer length) {
            this.length = length;
            return this;
        }

        public ReferenceBuilder value(ThreadLocal<Object> value) {
            this.value$value = value;
            this.value$set = true;
            return this;
        }

        public Reference build() {
            Boolean decodingIgnore$value = this.decodingIgnore$value;
            if (!this.decodingIgnore$set) {
                decodingIgnore$value = Reference.$default$decodingIgnore();
            }
            Boolean encodingIgnore$value = this.encodingIgnore$value;
            if (!this.encodingIgnore$set) {
                encodingIgnore$value = Reference.$default$encodingIgnore();
            }
            ThreadLocal value$value = this.value$value;
            if (!this.value$set) {
                value$value = Reference.$default$value();
            }
            return new Reference(this.referenceType, this.endianPolicy, decodingIgnore$value, encodingIgnore$value, this.protocolClass, this.constructorType, this.enableCompress, this.enableProtocolVersions, this.enableChecksum, this.enableCrypto, this.enableFixedLength, this.field, this.typeAnnotation, this.protocolType, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.byteOffset, this.bitOffset, this.size, this.length, value$value);
        }

        public String toString() {
            return "Reference.ReferenceBuilder(referenceType=" + (Object)((Object)this.referenceType) + ", endianPolicy=" + (Object)((Object)this.endianPolicy) + ", decodingIgnore$value=" + this.decodingIgnore$value + ", encodingIgnore$value=" + this.encodingIgnore$value + ", protocolClass=" + this.protocolClass + ", constructorType=" + (Object)((Object)this.constructorType) + ", enableCompress=" + this.enableCompress + ", enableProtocolVersions=" + this.enableProtocolVersions + ", enableChecksum=" + this.enableChecksum + ", enableCrypto=" + this.enableCrypto + ", enableFixedLength=" + this.enableFixedLength + ", field=" + this.field + ", typeAnnotation=" + this.typeAnnotation + ", protocolType=" + this.protocolType + ", decoderClass=" + this.decoderClass + ", encoderClass=" + this.encoderClass + ", decodeFormula=" + this.decodeFormula + ", encodeFormula=" + this.encodeFormula + ", decoder=" + this.decoder + ", encoder=" + this.encoder + ", byteOffset=" + this.byteOffset + ", bitOffset=" + this.bitOffset + ", size=" + this.size + ", length=" + this.length + ", value$value=" + this.value$value + ")";
        }
    }

    public static enum ConstructorType {
        NO_ARGS,
        ALL_ARGS;

    }

    public static enum ReferenceType {
        CLASS,
        FIELD,
        INVALID;

    }
}

