/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.IntPredicate;
import org.indunet.fastproto.annotation.EnableProtocolVersion;
import org.indunet.fastproto.annotation.EnableProtocolVersions;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;

public class EnableVersionFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Class<?> protocolClass = reference.getProtocolClass();
        ArrayList<EnableProtocolVersion> versions = new ArrayList<EnableProtocolVersion>();
        if (protocolClass.isAnnotationPresent(EnableProtocolVersions.class)) {
            EnableProtocolVersions enableProtocolVersions = protocolClass.getAnnotation(EnableProtocolVersions.class);
            Arrays.stream(enableProtocolVersions.value()).forEach(versions::add);
        }
        if (protocolClass.isAnnotationPresent(EnableProtocolVersion.class)) {
            versions.add(protocolClass.getAnnotation(EnableProtocolVersion.class));
        }
        IntPredicate validator = v -> v < 0 || v > 255;
        boolean flag = versions.stream().mapToInt(EnableProtocolVersion::version).anyMatch(validator);
        if (flag) {
            throw new ResolveException(String.format("Illegal protocol version for %s which must be uint8.", protocolClass.getName()));
        }
        reference.setEnableProtocolVersions(versions);
        this.forward(reference);
    }
}

