/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class BinaryCodec
implements Codec<byte[]> {
    public byte[] decode(byte[] bytes, int offset, int length) {
        try {
            return CodecUtils.binaryType(bytes, offset, length);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding binary type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, byte[] values) {
        try {
            CodecUtils.binaryType(bytes, offset, length, values);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding binary type.", (Throwable)e);
        }
    }

    @Override
    public byte[] decode(CodecContext context, byte[] bytes) {
        BinaryType type = context.getDataType(BinaryType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, byte[] value) {
        BinaryType type = context.getDataType(BinaryType.class);
        this.encode(bytes, type.offset(), type.length(), value);
    }
}

