/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.annotation.type.BoolType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class BoolCodec
implements Codec<Boolean> {
    public boolean decode(byte[] bytes, int byteOffset, int bitOffset) {
        try {
            return CodecUtils.boolType(bytes, byteOffset, bitOffset);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding boolean type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int byteOffset, int bitOffset, boolean value) {
        try {
            CodecUtils.boolType(datagram, byteOffset, bitOffset, value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the boolean type.", (Throwable)e);
        }
    }

    @Override
    public Boolean decode(CodecContext context, byte[] bytes) {
        BoolType type = context.getDataType(BoolType.class);
        return this.decode(bytes, type.byteOffset(), type.bitOffset());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Boolean value) {
        BoolType type = context.getDataType(BoolType.class);
        this.encode(bytes, type.byteOffset(), type.bitOffset(), value);
    }
}

