/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.Int8Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ByteCodec
implements Codec<Byte> {
    public byte decode(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        try {
            return CodecUtils.byteType(datagram, offset);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int8(byte) type.", (Throwable)e);
        }
    }

    public void encode(@NonNull byte[] datagram, int offset, byte value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        try {
            CodecUtils.byteType(datagram, offset, value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int8(byte) type.", (Throwable)e);
        }
    }

    @Override
    public Byte decode(CodecContext context, byte[] bytes) {
        Int8Type type = context.getDataType(Int8Type.class);
        return this.decode(bytes, type.offset());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Byte value) {
        Int8Type type = context.getDataType(Int8Type.class);
        this.encode(bytes, type.offset(), (byte)value);
    }
}

