/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.annotation.type.CharType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class CharCodec
implements Codec<Character> {
    public Character decode(byte[] datagram, int offset) {
        try {
            int num = CodecUtils.uint8Type(datagram, offset);
            if (num > 127) {
                throw new DecodingException(String.format("%d is not valid ascii.", num));
            }
            return Character.valueOf((char)num);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding char type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, char value) {
        try {
            int num = Character.getNumericValue(value);
            if (num > 127) {
                throw new EncodingException(String.format("%c is not valid ascii.", Character.valueOf(value)));
            }
            CodecUtils.uint8Type(datagram, offset, value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding char type.", (Throwable)e);
        }
    }

    @Override
    public Character decode(CodecContext context, byte[] bytes) {
        CharType type = context.getDataType(CharType.class);
        return this.decode(bytes, type.offset());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Character value) {
        CharType type = context.getDataType(CharType.class);
        this.encode(bytes, type.offset(), value.charValue());
    }
}

