/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class DoubleCodec
implements Codec<Double> {
    public double decode(byte[] datagram, int offset, EndianPolicy policy) {
        try {
            return CodecUtils.doubleType(datagram, offset, policy);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding double type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, EndianPolicy policy, double value) {
        try {
            CodecUtils.doubleType(datagram, offset, policy, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding double type.", (Throwable)e);
        }
    }

    @Override
    public Double decode(CodecContext context, byte[] bytes) {
        DoubleType type = context.getDataType(DoubleType.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Double value) {
        DoubleType type = context.getDataType(DoubleType.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(bytes, type.offset(), policy, value);
    }
}

