/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.Int64Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int64Codec
implements Codec<Long> {
    public long decode(byte[] bytes, int byteOffset, EndianPolicy endian) {
        try {
            return CodecUtils.int64Type(bytes, byteOffset, endian);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int64 type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, long value) {
        try {
            CodecUtils.int64Type(bytes, offset, policy, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int64 type.", (Throwable)e);
        }
    }

    @Override
    public Long decode(CodecContext context, byte[] bytes) {
        Int64Type type = context.getDataType(Int64Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Long value) {
        Int64Type type = context.getDataType(Int64Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(bytes, type.offset(), policy, value);
    }
}

