/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.annotation.type.Int8Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int8Codec
implements Codec<Integer> {
    public int decode(byte[] bytes, int offset) {
        try {
            return CodecUtils.int8Type(bytes, offset);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int8(int) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int value) {
        try {
            CodecUtils.int8Type(bytes, offset, value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int8(int) type.", (Throwable)e);
        }
    }

    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        Int8Type type = context.getDataType(Int8Type.class);
        return this.decode(bytes, type.offset());
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Integer value) {
        Int8Type type = context.getDataType(Int8Type.class);
        this.encode(bytes, type.offset(), (int)value);
    }
}

