/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.nio.charset.Charset;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class StringBufferCodec
implements Codec<StringBuffer> {
    public StringBuffer decode(byte[] bytes, int offset, int length, Charset charset) {
        try {
            byte[] binary = CodecUtils.binaryType(bytes, offset, length);
            String str = new String(binary, charset);
            return new StringBuffer(str);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding StringBuffer type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, int length, Charset set, StringBuffer value) {
        try {
            CodecUtils.binaryType(datagram, offset, length, value.toString().getBytes());
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding StringBuffer type.", (Throwable)e);
        }
    }

    @Override
    public StringBuffer decode(CodecContext context, byte[] bytes) {
        StringType type = context.getDataType(StringType.class);
        return this.decode(bytes, type.offset(), type.length(), Charset.forName(type.charset()));
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, StringBuffer value) {
        StringType type = context.getDataType(StringType.class);
        Charset charset = Charset.forName(type.charset());
        this.encode(bytes, type.offset(), type.length(), charset, value);
    }
}

