/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.nio.charset.Charset;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class StringCodec
implements Codec<String> {
    public String decode(byte[] bytes, int offset, int length, Charset charset) {
        try {
            byte[] binary = CodecUtils.binaryType(bytes, offset, length);
            return new String(binary, charset);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding string type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, int length, Charset set, String value) {
        try {
            CodecUtils.binaryType(datagram, offset, length, value.getBytes());
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding string type.", (Throwable)e);
        }
    }

    @Override
    public String decode(CodecContext context, byte[] bytes) {
        StringType type = context.getDataType(StringType.class);
        return this.decode(bytes, type.offset(), type.length(), Charset.forName(type.charset()));
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, String value) {
        StringType type = context.getDataType(StringType.class);
        Charset charset = Charset.forName(type.charset());
        this.encode(bytes, type.offset(), type.length(), charset, value);
    }
}

