/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInt32Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt32Codec
implements Codec<Long> {
    public long decode(byte[] bytes, int offset, EndianPolicy policy) {
        try {
            return CodecUtils.uint32Type(bytes, offset, policy);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint32 type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, long value) {
        try {
            CodecUtils.uint32Type(bytes, offset, policy, value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint32 type.", (Throwable)e);
        }
    }

    @Override
    public Long decode(CodecContext context, byte[] bytes) {
        UInt32Type type = context.getDataType(UInt32Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Long value) {
        UInt32Type type = context.getDataType(UInt32Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(bytes, type.offset(), policy, value);
    }
}

