/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.ArrayType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.ReverseUtils;
import org.indunet.fastproto.util.TypeUtils;

public class ArrayDecoder
implements TypeDecoder<Object> {
    @Override
    public Object decode(DecodeContext context) {
        ArrayType type = context.getTypeAnnotation(ArrayType.class);
        int length = type.length();
        Class<?> componentType = context.getReference().getField().getType().getComponentType();
        return this.decode(context.getDatagram(), type.value(), length, type.genericType(), context.getEndianPolicy(), componentType.isPrimitive());
    }

    public Object decode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull Class<? extends Annotation> type, @NonNull EndianPolicy policy) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        return this.decode(datagram, byteOffset, length, type, policy, false);
    }

    public Object decode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull Class<? extends Annotation> type, @NonNull EndianPolicy policy, boolean primitive) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int size = TypeUtils.size(type);
        int bo = ReverseUtils.offset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (length <= 0) {
            throw new DecodingException(CodecError.ILLEGAL_PARAMETER);
        }
        if (bo + size * length > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        ArrayList list = new ArrayList();
        Consumer<Function> codec = func -> IntStream.range(0, length).parallel().forEachOrdered(i -> list.add(func.apply(i * size + bo)));
        if (type == ProtocolType.CHAR) {
            codec.accept(b -> Character.valueOf(CodecUtils.charType(datagram, (int)b, policy)));
            return primitive ? TypeUtils.listToArray(list, new char[length]) : list.toArray(new Character[length]);
        }
        if (type == ProtocolType.BYTE) {
            codec.accept(b -> CodecUtils.byteType(datagram, b));
            return primitive ? TypeUtils.listToArray(list, new byte[length]) : list.toArray(new Byte[length]);
        }
        if (type == ProtocolType.SHORT) {
            codec.accept(b -> CodecUtils.shortType(datagram, (int)b, policy));
            return primitive ? TypeUtils.listToArray(list, new short[length]) : list.toArray(new Short[length]);
        }
        if (type == ProtocolType.INT32) {
            codec.accept(b -> CodecUtils.int32Type(datagram, (int)b, policy));
            return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
        }
        if (type == ProtocolType.UINT64) {
            codec.accept(b -> CodecUtils.int64Type(datagram, (int)b, policy));
            return primitive ? TypeUtils.listToArray(list, new long[length]) : list.toArray(new Long[length]);
        }
        if (type == ProtocolType.UINT8) {
            codec.accept(b -> CodecUtils.uint8Type(datagram, b));
            return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
        }
        if (type == ProtocolType.UINT16) {
            codec.accept(b -> CodecUtils.uint16Type(datagram, (int)b, policy));
            return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
        }
        if (type == ProtocolType.UINT32) {
            codec.accept(b -> CodecUtils.uint32Type(datagram, (int)b, policy));
            return primitive ? TypeUtils.listToArray(list, new long[length]) : list.toArray(new Long[length]);
        }
        if (type == ProtocolType.INT8) {
            codec.accept(b -> CodecUtils.int8Type(datagram, b));
            return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
        }
        if (type == ProtocolType.INT16) {
            codec.accept(b -> CodecUtils.int16Type(datagram, (int)b, policy));
            return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
        }
        if (type == ProtocolType.FLOAT) {
            codec.accept(b -> Float.valueOf(CodecUtils.floatType(datagram, (int)b, policy)));
            return primitive ? TypeUtils.listToArray(list, new float[length]) : list.toArray(new Float[length]);
        }
        if (type == ProtocolType.DOUBLE) {
            codec.accept(b -> CodecUtils.doubleType(datagram, (int)b, policy));
            return primitive ? TypeUtils.listToArray(list, new double[length]) : list.toArray(new Double[length]);
        }
        throw new DecodingException(MessageFormat.format(CodecError.NOT_SUPPORT_ARRAY_TYPE.getMessage(), type.toString()));
    }
}

