/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.CharType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class CharacterDecoder
implements TypeDecoder<Character> {
    @Override
    public Character decode(DecodeContext context) {
        CharType type = context.getTypeAnnotation(CharType.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(context.getDatagram(), type.offset(), policy);
    }

    public Character decode(byte[] datagram, int offset, @NonNull EndianPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        try {
            return Character.valueOf(CodecUtils.charType(datagram, offset, policy));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding the character type.", (Throwable)e);
        }
    }
}

