/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class DoubleDecoder
implements TypeDecoder<Double> {
    @Override
    public Double decode(DecodeContext context) {
        DoubleType type = context.getTypeAnnotation(DoubleType.class);
        return this.decode(context.getDatagram(), type.offset(), context.getEndianPolicy());
    }

    public double decode(@NonNull byte[] datagram, int offset, @NonNull EndianPolicy endian) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        try {
            return CodecUtils.doubleType(datagram, offset, endian);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding the double type.", (Throwable)e);
        }
    }
}

