/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.ListType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.ReverseUtils;
import org.indunet.fastproto.util.TypeUtils;

public class ListDecoder
implements TypeDecoder<List<?>> {
    @Override
    public List<?> decode(DecodeContext context) {
        ListType type = context.getTypeAnnotation(ListType.class);
        return this.decode(context.getDatagram(), type.offset(), type.length(), type.genericType(), context.getEndianPolicy());
    }

    public List decode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull Class<? extends Annotation> type, @NonNull EndianPolicy policy) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int size = TypeUtils.size(type);
        int bo = ReverseUtils.offset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (length <= 0) {
            throw new DecodingException(CodecError.ILLEGAL_PARAMETER);
        }
        if (bo + size * length > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        BiFunction<Function, List, List> codec = (func, list) -> {
            IntStream.range(0, length).parallel().forEachOrdered(i -> list.add(func.apply(i * size + bo)));
            return list;
        };
        if (type == ProtocolType.CHAR) {
            return codec.apply(b -> Character.valueOf(CodecUtils.charType(datagram, (int)b, policy)), new ArrayList());
        }
        if (type == ProtocolType.BYTE) {
            return codec.apply(b -> CodecUtils.byteType(datagram, b), new ArrayList());
        }
        if (type == ProtocolType.SHORT) {
            return codec.apply(b -> CodecUtils.shortType(datagram, (int)b, policy), new ArrayList());
        }
        if (type == ProtocolType.INT32) {
            return codec.apply(b -> CodecUtils.int32Type(datagram, (int)b, policy), new ArrayList());
        }
        if (type == ProtocolType.UINT64) {
            return codec.apply(b -> CodecUtils.int64Type(datagram, (int)b, policy), new ArrayList());
        }
        if (type == ProtocolType.UINT8) {
            return codec.apply(b -> CodecUtils.uint8Type(datagram, b), new ArrayList());
        }
        if (type == ProtocolType.UINT16) {
            return codec.apply(b -> CodecUtils.uint16Type(datagram, (int)b, policy), new ArrayList());
        }
        if (type == ProtocolType.UINT32) {
            return codec.apply(b -> CodecUtils.uint32Type(datagram, (int)b, policy), new ArrayList());
        }
        if (type == ProtocolType.INT8) {
            return codec.apply(b -> CodecUtils.int8Type(datagram, b), new ArrayList());
        }
        if (type == ProtocolType.INT16) {
            return codec.apply(b -> CodecUtils.int16Type(datagram, (int)b, policy), new ArrayList());
        }
        if (type == ProtocolType.FLOAT) {
            return codec.apply(b -> Float.valueOf(CodecUtils.floatType(datagram, (int)b, policy)), new ArrayList());
        }
        if (type == ProtocolType.DOUBLE) {
            return codec.apply(b -> CodecUtils.doubleType(datagram, (int)b, policy), new ArrayList());
        }
        throw new DecodingException(MessageFormat.format(CodecError.NOT_SUPPORT_ARRAY_TYPE.getMessage(), type.toString()));
    }
}

