/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.ShortType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ShortDecoder
implements TypeDecoder<Short> {
    @Override
    public Short decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ShortType type = context.getTypeAnnotation(ShortType.class);
        return this.decode(context.getDatagram(), type.offset(), context.getEndianPolicy());
    }

    public short decode(@NonNull byte[] datagram, int offset, @NonNull EndianPolicy policy) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        try {
            return CodecUtils.shortType(datagram, offset, policy);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding the short type.", (Throwable)e);
        }
    }
}

