/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.lang.annotation.Annotation;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.TimeType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.ReverseUtils;

public class TimestampDecoder<T extends Date>
implements TypeDecoder<T> {
    @Override
    public T decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        EndianPolicy policy = context.getEndianPolicy();
        TimeType type = context.getTypeAnnotation(TimeType.class);
        Class<?> clazz = context.getReference().getField().getType();
        return (T)this.decode(context.getDatagram(), type.offset(), type.genericType(), policy, type.unit(), clazz);
    }

    public T decode(@NonNull byte[] datagram, int byteOffset, @NonNull Class<? extends Annotation> genericType, @NonNull EndianPolicy policy, @NonNull TimeUnit unit, Class<T> fieldType) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (genericType == null) {
            throw new NullPointerException("genericType is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        Function<Long, Date> newInstance = v -> {
            if (fieldType == Timestamp.class) {
                return new Timestamp((long)v);
            }
            return new Date((long)v);
        };
        int bo = ReverseUtils.offset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (genericType == ProtocolType.INT64 && unit == TimeUnit.MILLISECONDS) {
            if (bo + 8 > datagram.length) {
                throw new DecodingException(CodecError.EXCEEDED_DATAGRAM_SIZE);
            }
            long value = CodecUtils.int64Type(datagram, bo, policy);
            return (T)newInstance.apply(value);
        }
        if (genericType == ProtocolType.UINT32 && unit == TimeUnit.SECONDS) {
            if (bo + 4 > datagram.length) {
                throw new DecodingException(CodecError.EXCEEDED_DATAGRAM_SIZE);
            }
            long value = CodecUtils.uint32Type(datagram, bo, policy);
            return (T)newInstance.apply(value * 1000L);
        }
        throw new DecodingException(CodecError.ILLEGAL_TIMESTAMP_PARAMETERS);
    }
}

