/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class BinaryEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        BinaryType type = context.getTypeAnnotation(BinaryType.class);
        byte[] bytes = context.getValue(byte[].class);
        this.encode(context.getDatagram(), type.offset(), type.length(), bytes);
    }

    public void encode(@NonNull byte[] datagram, int offset, int length, @NonNull byte[] bytes) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        try {
            CodecUtils.binaryType(datagram, offset, length, bytes);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the binary type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException("Fail encoding the binary type.", (Throwable)e);
        }
    }
}

