/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.annotation.type.BoolType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class BooleanEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        BoolType type = context.getTypeAnnotation(BoolType.class);
        Boolean value = context.getValue(Boolean.class);
        this.encode(context.getDatagram(), type.byteOffset(), type.bitOffset(), value);
    }

    public void encode(byte[] datagram, int byteOffset, int bitOffset, boolean value) {
        try {
            CodecUtils.boolType(datagram, byteOffset, bitOffset, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the boolean type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException("Fail encoding the boolean type.", (Throwable)e);
        }
    }
}

