/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ByteEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ByteType type = context.getTypeAnnotation(ByteType.class);
        Byte value = context.getValue(Byte.class);
        this.encode(context.getDatagram(), type.offset(), value);
    }

    public void encode(@NonNull byte[] datagram, int offset, byte value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        try {
            CodecUtils.byteType(datagram, offset, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the byte type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException("Fail encoding the byte type.", (Throwable)e);
        }
    }
}

