/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.annotation.type.Int8Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Integer8Encoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        Int8Type type = context.getTypeAnnotation(Int8Type.class);
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.offset(), value);
    }

    public void encode(byte[] datagram, int offset, int value) {
        try {
            CodecUtils.int8Type(datagram, offset, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the integer8 type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException("Fail encoding the integer8 type.", (Throwable)e);
        }
    }
}

