/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.Int32Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class IntegerEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Int32Type type = context.getTypeAnnotation(Int32Type.class);
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.offset(), context.getEndianPolicy(), value);
    }

    public void encode(@NonNull byte[] datagram, int offset, @NonNull EndianPolicy policy, int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        try {
            CodecUtils.int32Type(datagram, offset, policy, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the integer type.", (Throwable)e);
        }
    }
}

