/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.UInt8Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInteger8Encoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        UInt8Type type = context.getTypeAnnotation(UInt8Type.class);
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.offset(), value);
    }

    public void encode(@NonNull byte[] datagram, int offset, int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        try {
            CodecUtils.uint8Type(datagram, offset, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the uinteger8 type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException("Fail encoding the uinteger8 type.", (Throwable)e);
        }
    }
}

