/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Consumer;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.EncoderFactory;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.ReferenceGraph;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.Pipeline;

public class EncodeFlow
extends Pipeline<CodecContext> {
    @Override
    public void process(CodecContext context) {
        ReferenceGraph graph = context.getReferenceGraph();
        Object object = context.getObject();
        byte[] datagram = context.getDatagram();
        List<EncodeContext> encodeContexts = graph.encodeContexts(object, datagram);
        encodeContexts.forEach(c -> {
            Reference ref = c.getReference();
            try {
                if (ref.getEncodeFormula() != null) {
                    Object o = EncoderFactory.getFormula(ref.getEncodeFormula()).apply(c.getValue());
                    c.setValue(o);
                }
                Consumer<EncodeContext> consumer = EncoderFactory.getEncoder(ref.getEncoderClass());
                consumer.accept((EncodeContext)c);
            }
            catch (EncodingException e) {
                throw new EncodingException(MessageFormat.format(CodecError.FAIL_ENCODING_FIELD.getMessage(), ref.getField().toString()), (Throwable)e);
            }
        });
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 512L;
    }
}

