/*
 * Copyright 2019-2021 indunet.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.indunet.fastproto.reference.resolve.validate;

import lombok.val;
import org.indunet.fastproto.annotation.type.ListType;
import org.indunet.fastproto.exception.ResolveException;

import java.util.Arrays;

/**
 * Abstract flow.
 *
 * @author Deng Ran
 * @since 2.3.0
 */
public class ListValidator extends TypeValidator {
    @Override
    public void process(ValidatorContext context) {
        val type = (ListType) context.getTypeAnnotation();

        if (!Arrays.stream(ListType.ALLOWED_GENERIC_TYPES)
                .anyMatch(t -> t == type.genericType())) {
            throw new ResolveException("Illegal generic type for list.");
        }
    }
}
