/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.Int16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int16Codec
implements Codec<Integer> {
    public int decode(byte[] bytes, int byteOffset, EndianPolicy policy) {
        try {
            return CodecUtils.int16Type(bytes, byteOffset, policy);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int16(int) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, int value) {
        try {
            CodecUtils.int16Type(bytes, offset, policy, value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int16(int) type.", (Throwable)e);
        }
    }

    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Integer value) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(bytes, type.offset(), policy, value);
    }
}

