/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.math.BigInteger;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInt64Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt64Codec
implements Codec<BigInteger> {
    public BigInteger decode(byte[] bytes, int offset, EndianPolicy policy) {
        try {
            return CodecUtils.uint64Type(bytes, offset, policy);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint64 type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, EndianPolicy policy, BigInteger value) {
        try {
            CodecUtils.uint64Type(bytes, offset, policy, value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding uint64 type.", (Throwable)e);
        }
    }

    @Override
    public BigInteger decode(CodecContext context, byte[] bytes) {
        UInt64Type type = context.getDataTypeAnnotation(UInt64Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, BigInteger value) {
        UInt64Type type = context.getDataTypeAnnotation(UInt64Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(bytes, type.offset(), policy, value);
    }
}

