/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import java.util.List;
import lombok.NonNull;
import org.indunet.fastproto.annotation.EnableProtocolVersion;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.ProtocolVersionException;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;
import org.indunet.fastproto.reference.Reference;
import org.indunet.fastproto.util.CodecUtils;

public class VerifyVersionFlow
extends Pipeline<PipelineContext> {
    @Override
    public void process(@NonNull PipelineContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Reference reference = context.getGraph().root();
        List<EnableProtocolVersion> versions = reference.getEnableProtocolVersions();
        byte[] bytes = context.getDatagram();
        boolean flag = versions.stream().anyMatch(v -> v.version() != CodecUtils.uint8Type(bytes, v.offset()));
        if (flag) {
            throw new ProtocolVersionException(CodecError.PROTOCOL_VERSION_NOT_MATCH);
        }
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 16L;
    }
}

