/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.reference.resolve;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.indunet.fastproto.annotation.Constructor;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.reference.Reference;
import org.indunet.fastproto.reference.resolve.ResolvePipeline;

public class ConstructorFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Class<?> protocolClass = reference.getProtocolClass();
        int cnt = 0;
        cnt = Arrays.stream(protocolClass.getConstructors()).anyMatch(c -> c.isAnnotationPresent(Constructor.class)) ? Arrays.stream(protocolClass.getConstructors()).filter(c -> c.isAnnotationPresent(Constructor.class)).findAny().get().getParameterCount() : Arrays.stream(protocolClass.getConstructors()).mapToInt(c -> c.getParameterCount()).min().getAsInt();
        if (cnt == 0) {
            reference.setConstructorType(Reference.ConstructorType.NO_ARGS);
        } else {
            Class[] paramTypes = (Class[])Arrays.stream(protocolClass.getDeclaredFields()).filter(f -> !Modifier.isTransient(f.getModifiers())).map(Field::getType).toArray(Class[]::new);
            try {
                protocolClass.getConstructor(paramTypes);
                reference.setConstructorType(Reference.ConstructorType.ALL_ARGS);
            }
            catch (NoSuchMethodException e) {
                throw new ResolveException(String.format("The constructor parameters of %s and class fields does not match.", protocolClass.getName()), (Throwable)e);
            }
        }
        this.forward(reference);
    }
}

