/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.reference.resolve;

import java.util.function.Supplier;
import org.indunet.fastproto.annotation.EnableCrypto;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CryptoException;
import org.indunet.fastproto.reference.Reference;
import org.indunet.fastproto.reference.resolve.ResolvePipeline;

public class EnableCryptoFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Class<?> protocolClass = reference.getProtocolClass();
        if (protocolClass.isAnnotationPresent(EnableCrypto.class)) {
            EnableCrypto enableCrypto = protocolClass.getAnnotation(EnableCrypto.class);
            if (!enableCrypto.key().isEmpty()) {
                byte[] key = enableCrypto.key().getBytes();
                reference.setEnableCrypto(enableCrypto);
            } else if (enableCrypto.keySupplier().length != 0) {
                Class<? extends Supplier<byte[]>> keySupplier = enableCrypto.keySupplier()[0];
                try {
                    byte[] key = keySupplier.newInstance().get();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new CryptoException(CodecError.INVALID_CRYPTO_KEY_SUPPLIER, (Throwable)e);
                }
            } else {
                throw new CryptoException(CodecError.NO_CRYPTO_KEY);
            }
        }
        this.forward(reference);
    }
}

