/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.reference.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.DataType;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.reference.Reference;
import org.indunet.fastproto.reference.resolve.ResolvePipeline;
import org.indunet.fastproto.util.TypeUtils;

public class TypeAnnotationFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Field field = reference.getField();
        Annotation typeAnnotation = Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(DataType.class)).findAny().orElseThrow(ResolveException::new);
        reference.setDataTypeAnnotation(typeAnnotation);
        reference.setReferenceType(Reference.ReferenceType.FIELD);
        reference.setDecodeFormulaClass(TypeUtils.decodingFormula(typeAnnotation));
        reference.setEncodeFormulaClass(TypeUtils.encodingFormula(typeAnnotation));
        reference.setProtocolType(ProtocolType.proxy(typeAnnotation));
        this.forward(reference);
    }
}

